/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform.processors;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import org.glassfish.websocket.api.annotations.PathSegment;
import org.glassfish.websocket.api.annotations.WebSocketMessage;

public class OnMessageMethodHelper {
    ExecutableElement element;

    public OnMessageMethodHelper(ExecutableElement element) {
        if (element.getParameters().size() > 3) {
            throw new RuntimeException("Cannot deal with methods with more than 2 parameters right now. Sorry.");
        }
        if (element.getParameters().size() < 1) {
            throw new RuntimeException("Cannot deal with methods with no parameters right now. Sorry.");
        }
        this.element = element;
    }

    public String getMethodName() {
        return this.element.getSimpleName().toString();
    }

    public TypeMirror getReturnTypeMirror() {
        return this.element.getReturnType();
    }

    public boolean hasReturn() {
        return !(this.getReturnTypeMirror() instanceof NoType);
    }

    public WebSocketMessage getAnnotation() {
        return this.element.getAnnotation(WebSocketMessage.class);
    }

    public VariableElement getDataParameterElement() {
        return this.element.getParameters().get(0);
    }

    public VariableElement getPeerParameterElement() {
        if (this.element.getParameters().size() > 1) {
            for (int i = 1; i < this.element.getParameters().size(); ++i) {
                VariableElement ve = this.element.getParameters().get(i);
                if (OnMessageMethodHelper.isDynamicPath(ve)) continue;
                return ve;
            }
        }
        return null;
    }

    static boolean isDynamicPath(VariableElement parameter) {
        PathSegment ps = parameter.getAnnotation(PathSegment.class);
        return ps != null;
    }

    public VariableElement getDynamicPathParameterElement() {
        for (VariableElement variableElement : this.element.getParameters()) {
            if (!OnMessageMethodHelper.isDynamicPath(variableElement)) continue;
            return variableElement;
        }
        return null;
    }
}

