/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform.processors;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import org.glassfish.websocket.api.annotations.WebSocket;
import org.glassfish.websocket.api.annotations.WebSocketError;
import org.glassfish.websocket.platform.WebSocketEndpoint;
import org.glassfish.websocket.platform.processors.OnMessageMethodHelper;
import org.glassfish.websocket.platform.processors.ProcessorUtils;
import org.glassfish.websocket.platform.processors.RemoteProcessor;

public class MethodWriter {
    static String getClassLevelPath(Element clazz) {
        WebSocket ws = clazz.getAnnotation(WebSocket.class);
        if (ws != null) {
            return ws.path();
        }
        return "";
    }

    static void writeExceptionHandlerMethodBody(TypeElement clazz, Set<Element> methods, PrintWriter pw) {
        for (Element method : methods) {
            WebSocketError wse = method.getAnnotation(WebSocketError.class);
            if (wse == null) continue;
            String endPointPath = MethodWriter.getClassLevelPath(clazz);
            pw.println("\t\tif (true) {");
            pw.println("\t\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");
            pw.println("\t\t\tbean." + method.getSimpleName() + "(e, wsw);");
            pw.println("\t\t}");
        }
    }

    static boolean checkRemoteMatching(TypeElement clazz, String remoteImpl, RemoteProcessor rp) {
        boolean match = false;
        String classDeclaredRemoteImpl = "";
        WebSocket wsa = clazz.getAnnotation(WebSocket.class);
        String classLevelRemoteIfc = MethodWriter.getRemoteClassFromWebSocket(wsa);
        if (!classLevelRemoteIfc.equals("java.lang.Object")) {
            classDeclaredRemoteImpl = rp.getImplementationFor(classLevelRemoteIfc);
            match = classDeclaredRemoteImpl.equals(remoteImpl);
        }
        if (!match) {
            throw new RuntimeException("Syntax error ?  A method on class :" + clazz.getQualifiedName() + ": is looking for an :" + remoteImpl + ": But its class declares :" + classLevelRemoteIfc + ": as a remote ifc with impl is :" + classDeclaredRemoteImpl + ":. ???");
        }
        return true;
    }

    static void writeOnOpenMethod(TypeElement clazz, Element method, RemoteProcessor rp, PrintWriter pw) {
        String openMethodName = method.getSimpleName().toString();
        ExecutableElement eMethod = (ExecutableElement)method;
        pw.println("\tpublic void onConnect(WebSocket socket) {");
        pw.println("\t\tsuper.onConnect(socket);");
        if (eMethod.getParameters().size() == 1) {
            VariableElement ve = eMethod.getParameters().get(0);
            String remoteInterface = ((Object)ve.asType()).toString();
            String riclz = rp.getImplementationFor(remoteInterface);
            if (riclz == null) {
                pw.println("\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");
            } else {
                MethodWriter.checkRemoteMatching(clazz, riclz, rp);
                pw.println("\t\t\t" + riclz + " wsw = (" + riclz + ") WebSocketWrapper.getWebSocketWrapper(socket, this);");
            }
        } else {
            throw new RuntimeException("onConnect method " + openMethodName + "must have one parameter");
        }
        pw.println("\t\tbean." + openMethodName + "(wsw);");
        pw.println("\t}");
    }

    static void writeOnMessageMethod(TypeElement clazz, List<Element> methods, RemoteProcessor rp, PrintWriter pw) throws IOException {
        pw.println("\tpublic void onMessage(WebSocket socket, String messageString) {");
        for (Element nextMethod : methods) {
            MethodWriter.writeOnMessageCallbackBlockFor(clazz, nextMethod, rp, pw);
        }
        pw.println("\t}");
    }

    private static void writeOnMessageCallbackBlockFor(TypeElement clazz, Element method, RemoteProcessor rp, PrintWriter pw) throws IOException {
        ExecutableElement methodAsMethod = (ExecutableElement)method;
        OnMessageMethodHelper onMessageMethodHelper = new OnMessageMethodHelper(methodAsMethod);
        String endPointPath = MethodWriter.getClassLevelPath(clazz);
        String dynamicPath = onMessageMethodHelper.getAnnotation().dynamicPath();
        pw.println("\t\tif (super.doesPathMatch(\"" + dynamicPath + "\")) {");
        if (onMessageMethodHelper.getPeerParameterElement() == null) {
            pw.println("\t\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");
        } else {
            String remoteInterface = ((Object)onMessageMethodHelper.getPeerParameterElement().asType()).toString();
            String riclz = rp.getImplementationFor(remoteInterface);
            if (riclz == null) {
                pw.println("\t\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");
            } else {
                MethodWriter.checkRemoteMatching(clazz, riclz, rp);
                pw.println("\t\t\t" + riclz + " wsw = (" + riclz + ") WebSocketWrapper.getWebSocketWrapper(socket, this);");
            }
        }
        pw.println("\t\t\ttry {");
        String varNameForDecodedMessage = "decodedMessage";
        String dataParameterClassname = ((Object)onMessageMethodHelper.getDataParameterElement().asType()).toString();
        String boxedDataParameterClassname = WebSocketEndpoint.getClassTypeForTypeThatMightBePrimitive(dataParameterClassname);
        pw.println("\t\t\t\t" + boxedDataParameterClassname + " " + varNameForDecodedMessage + " = (" + boxedDataParameterClassname + ") super.doDecode(messageString, \"" + dataParameterClassname + "\");");
        pw.println("\t\t\t\tif (" + varNameForDecodedMessage + " != null) {");
        String parametersToWrite = varNameForDecodedMessage;
        if (onMessageMethodHelper.getDynamicPathParameterElement() != null) {
            pw.println("\t\t\t\t\tString pathSegment = super.getPathSegment();");
            parametersToWrite = parametersToWrite + ", pathSegment";
        }
        if (onMessageMethodHelper.getPeerParameterElement() != null) {
            parametersToWrite = parametersToWrite + ", wsw";
        }
        if (!onMessageMethodHelper.hasReturn()) {
            pw.println("\t\t\t\t\tbean." + method.getSimpleName() + "(" + parametersToWrite + ");");
        } else {
            String returnClassname = ((Object)onMessageMethodHelper.getReturnTypeMirror()).toString();
            returnClassname = ProcessorUtils.convertPrimitiveToClassIfNec(returnClassname);
            pw.println("\t\t\t\t\t" + returnClassname + " returnMessage = bean." + onMessageMethodHelper.getMethodName() + "(" + parametersToWrite + ");");
            pw.println("\t\t\t\t\tString returnMessageAsString = super.doEncode(returnMessage);");
            pw.println("\t\t\t\t\twsw.sendMessage(returnMessageAsString);");
        }
        pw.println("\t\t\t\t}");
        pw.println("\t\t\t} catch (Exception exception) {");
        pw.println("\t\t\t\tthis.handleException(socket, exception);");
        pw.println("\t\t\t}");
        pw.println("\t\t}");
    }

    static String getRemoteClassFromWebSocket(WebSocket wsa) {
        TypeMirror value = null;
        try {
            wsa.remote();
        }
        catch (MirroredTypeException mte) {
            value = mte.getTypeMirror();
            return ((Object)value).toString();
        }
        throw new RuntimeException("Error getting decoder name from " + wsa);
    }

    static String getDecoderClassFromWebSocketForType(TypeElement clazz, String firstParameterClassname) {
        Object decoders = null;
        WebSocket wsa = clazz.getAnnotation(WebSocket.class);
        for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
            boolean isAmWebSocketTypeMirror = annotationMirror.getAnnotationType().toString().equals(WebSocket.class.getCanonicalName());
            if (!isAmWebSocketTypeMirror) continue;
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!executableElement.getSimpleName().toString().equals("decoders")) continue;
                List decodersL = (List)annotationMirror.getElementValues().get(executableElement).getValue();
                for (Object nextDecoderClassnameDotClass : decodersL) {
                    System.out.println("*" + nextDecoderClassnameDotClass);
                    boolean works = MethodWriter.doesDecoderWorkFor(nextDecoderClassnameDotClass.toString(), firstParameterClassname);
                    if (!works) continue;
                    return nextDecoderClassnameDotClass.toString();
                }
                throw new RuntimeException("Stop !!");
            }
        }
        return null;
    }

    static boolean doesDecoderWorkFor(String decoderClassname, String type2) {
        try {
            Class<?> decoderClass = Class.forName(decoderClassname.substring(0, decoderClassname.length() - 6));
            System.out.println("--" + decoderClass);
            System.out.println("**" + decoderClass.getGenericInterfaces());
            Class<?> typeClass = Class.forName(type2.substring(0, type2.length() - 5));
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            return false;
        }
    }

    private static String createVariableDeclarationForDecodedMessage(String firstParameterClassname, String varNameForDecodedMessage) {
        String variableDeclarationForDecodedMessage = "";
        if (firstParameterClassname.equals("java.lang.String")) {
            variableDeclarationForDecodedMessage = "String " + varNameForDecodedMessage + " = messageString;";
        } else if (firstParameterClassname.equals("boolean")) {
            variableDeclarationForDecodedMessage = "boolean " + varNameForDecodedMessage + " = (new Boolean(messageString)).booleanValue();";
        } else if (firstParameterClassname.equals("int")) {
            variableDeclarationForDecodedMessage = "int " + varNameForDecodedMessage + " = (new Integer(messageString)).intValue();";
        } else if (firstParameterClassname.equals("short")) {
            variableDeclarationForDecodedMessage = "short " + varNameForDecodedMessage + " = (new Short(messageString)).shortValue();";
        } else if (firstParameterClassname.equals("long")) {
            variableDeclarationForDecodedMessage = "long " + varNameForDecodedMessage + " = (new Long(messageString)).longValue();";
        } else if (firstParameterClassname.equals("char")) {
            variableDeclarationForDecodedMessage = "char " + varNameForDecodedMessage + " = messageString.charAt(0);";
        } else if (firstParameterClassname.equals("float")) {
            variableDeclarationForDecodedMessage = "float " + varNameForDecodedMessage + " = (new Float(messageString)).floatValue();";
        } else if (firstParameterClassname.equals("double")) {
            variableDeclarationForDecodedMessage = "double " + varNameForDecodedMessage + " = (new Double(messageString)).doubleValue();";
        } else if (MethodWriter.typeHasSingleStringConstructor(firstParameterClassname)) {
            variableDeclarationForDecodedMessage = firstParameterClassname + " " + varNameForDecodedMessage + " = new " + firstParameterClassname + "(messageString);";
        } else if (!"".equals(MethodWriter.typeHasFactoryMethod(firstParameterClassname))) {
            String methodName = MethodWriter.typeHasFactoryMethod(firstParameterClassname);
            variableDeclarationForDecodedMessage = firstParameterClassname + " " + varNameForDecodedMessage + " = " + firstParameterClassname + "." + methodName + "(messageString);";
        } else {
            System.out.println("AAAAAGH, ok it works , but don't do this !");
            variableDeclarationForDecodedMessage = "byte[] " + varNameForDecodedMessage + " = messageString.getBytes();";
        }
        return variableDeclarationForDecodedMessage;
    }

    private static boolean typeHasSingleStringConstructor(String firstParameterClassname) {
        try {
            Class<?> c = Class.forName(firstParameterClassname);
            for (Constructor<?> cons : c.getConstructors()) {
                if (cons.getParameterTypes().length != 1 || !cons.getParameterTypes()[0].equals(String.class)) continue;
                return true;
            }
        }
        catch (Throwable t) {
            System.out.println("Warning: cound not load " + firstParameterClassname);
        }
        return false;
    }

    private static String typeHasFactoryMethod(String firstParameterClassname) {
        try {
            Class<?> c = Class.forName(firstParameterClassname);
            for (Method method : c.getMethods()) {
                int modifiers = method.getModifiers();
                boolean isStatic = Modifier.isStatic(modifiers);
                boolean isPublic = Modifier.isPublic(modifiers);
                String name = method.getName();
                if (!isStatic || !isPublic) {
                    return "";
                }
                if (!name.equals("valueOf") && !name.equals("fromString") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
                return name;
            }
        }
        catch (Throwable t) {
            System.out.println("Warning: cound not load " + firstParameterClassname);
        }
        return "";
    }

    static void writeOnCloseMethod(TypeElement clazz, Element method, RemoteProcessor rp, PrintWriter pw) {
        String closeMethodName = method.getSimpleName().toString();
        ExecutableElement eMethod = (ExecutableElement)method;
        pw.println("\tpublic void onClose(WebSocket socket) {");
        if (eMethod.getParameters().size() == 1) {
            VariableElement ve = eMethod.getParameters().get(0);
            String remoteInterface = ((Object)ve.asType()).toString();
            String riclz = rp.getImplementationFor(remoteInterface);
            if (riclz == null) {
                pw.println("\t\tWebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);");
            } else {
                MethodWriter.checkRemoteMatching(clazz, riclz, rp);
                pw.println("\t\t\t" + riclz + " wsw = (" + riclz + ") WebSocketWrapper.getWebSocketWrapper(socket, this);");
            }
        } else {
            throw new RuntimeException("onOpen method " + closeMethodName + "must have one parameter");
        }
        pw.println("\t\tbean." + closeMethodName + "(wsw);");
        pw.println("\t}");
    }
}

