/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform.processors;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.glassfish.websocket.api.annotations.WebSocket;
import org.glassfish.websocket.api.annotations.WebSocketClose;
import org.glassfish.websocket.api.annotations.WebSocketContext;
import org.glassfish.websocket.api.annotations.WebSocketMessage;
import org.glassfish.websocket.api.annotations.WebSocketOpen;
import org.glassfish.websocket.platform.processors.MethodWriter;
import org.glassfish.websocket.platform.processors.RemoteProcessor;

public class ClassWriter {
    private static Element findContextInstanceVariableElement(TypeElement clazz) {
        for (Element element : clazz.getEnclosedElements()) {
            WebSocketContext wsc = element.getAnnotation(WebSocketContext.class);
            if (wsc == null) continue;
            return element;
        }
        return null;
    }

    public static void writeClass(String packageNameToWrite, String clazzNameToWrite, TypeElement clazz, Set<Element> methods, RemoteProcessor rp, PrintWriter pw) throws IOException {
        String wsaRemote;
        WebSocket wsa;
        String[] subprotocols;
        pw.println("package " + packageNameToWrite + ";");
        pw.println();
        ClassWriter.writeImports(pw, clazz);
        pw.println("public class " + clazzNameToWrite + " extends WebSocketEndpoint implements Initable {");
        pw.println("\tprivate " + clazz.getSimpleName() + " bean;");
        pw.println();
        pw.println("\tpublic " + clazzNameToWrite + "() {");
        pw.println("\t}");
        pw.println();
        Element contextIVElement = ClassWriter.findContextInstanceVariableElement(clazz);
        pw.println("\tpublic void doInit(String path, Set decoders, Set encoders, Object bean, Set methods) {");
        pw.println("\t\tsuper.path = path;");
        pw.println("\t\tthis.bean = (" + clazz.getSimpleName() + ") bean;");
        pw.println("\t\tsuper.encoders = encoders;");
        pw.println("\t\tsuper.decoders = decoders;");
        if (contextIVElement != null) {
            pw.println("\t\tthis.bean." + contextIVElement + " = super.endpointContext;");
        }
        if ((subprotocols = (wsa = clazz.getAnnotation(WebSocket.class)).subprotocols()) != null) {
            for (int i = 0; i < subprotocols.length; ++i) {
                pw.println("\t\tsuper.addSupportedSubprotocol(\"" + subprotocols[i] + "\");");
            }
        }
        if (!(wsaRemote = MethodWriter.getRemoteClassFromWebSocket(wsa)).equals("java.lang.Object")) {
            String riclz = rp.getImplementationFor(wsaRemote);
            pw.println("\t\tsuper.remoteImplClassname = \"" + riclz + "\";");
        }
        pw.println("\t}");
        pw.println();
        pw.println("\tvoid handleException(org.glassfish.grizzly.websockets.WebSocket socket, Exception e) {");
        pw.println("\t\tSystem.out.println(\"Error replying to client \" + e.getMessage());");
        pw.println("\t\te.printStackTrace();");
        MethodWriter.writeExceptionHandlerMethodBody(clazz, methods, pw);
        pw.println("\t}");
        pw.println();
        List<Element> onMessageMethods = ClassWriter.getOnMessageMethods(methods);
        MethodWriter.writeOnMessageMethod(clazz, onMessageMethods, rp, pw);
        for (Element nextMethod : methods) {
            if (nextMethod.getAnnotation(WebSocketOpen.class) != null) {
                MethodWriter.writeOnOpenMethod(clazz, nextMethod, rp, pw);
            } else if (nextMethod.getAnnotation(WebSocketClose.class) != null) {
                MethodWriter.writeOnCloseMethod(clazz, nextMethod, rp, pw);
            }
            pw.println();
        }
        pw.println("}");
    }

    private static List<Element> getOnMessageMethods(Set<Element> methods) {
        ArrayList<Element> onMessageMethods = new ArrayList<Element>();
        for (Element nextMethod : methods) {
            if (nextMethod.getAnnotation(WebSocketMessage.class) == null) continue;
            onMessageMethods.add(nextMethod);
        }
        return onMessageMethods;
    }

    public static void writeImports(PrintWriter pw, TypeElement eachClazz) {
        pw.println("import org.glassfish.grizzly.websockets.*;");
        pw.println("import org.glassfish.websocket.platform.*;");
        pw.println("import org.glassfish.websocket.api.*;");
        pw.println("import java.util.*;");
        pw.println("import " + eachClazz.getQualifiedName() + ";");
        pw.println();
    }
}

