/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform.main;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.websocket.platform.BeanServer;
import org.glassfish.websocket.platform.ContainerContextImpl;

public class Main {
    public static void setWebMode(boolean b) {
        ContainerContextImpl.setWebMode(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Please provide: (<hostname>, <port>, <websockets root path>, <;-sep fully qualfied classnames of your bean>) in the command line");
            System.out.println("e.g. localhost 8021 /websockets/myapp myapp.Bean1;myapp.Bean2");
            System.exit(0);
        }
        Set<Class<?>> beanClasses = Main.getClassesFromString(args[3]);
        int port = Integer.parseInt(args[1]);
        String hostname = args[0];
        String wsroot = args[2];
        HttpServer server = HttpServer.createSimpleServer(wsroot, port);
        server.getListener("grizzly").registerAddOn(new WebSocketAddOn());
        BeanServer bs = new BeanServer();
        try {
            bs.initWebSocketServer(wsroot, port, beanClasses);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Registered apps: URLs all start with ws://" + hostname + ":" + port);
        System.out.println("Registered.");
        try {
            server.start();
            System.out.println("Press any key to stop the server...");
            System.in.read();
        }
        catch (IOException ioe) {
            System.out.println("weird...");
        }
        finally {
            server.stop();
            System.out.println("Server stopped.");
        }
    }

    public static Set<Class<?>> getClassesFromString(String rawString) {
        HashSet beanClasses = new HashSet();
        StringTokenizer st = new StringTokenizer(rawString, ";");
        while (st.hasMoreTokens()) {
            String nextClassname = st.nextToken().trim();
            if ("".equals(nextClassname)) continue;
            try {
                beanClasses.add(Class.forName(nextClassname));
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Stop: cannot load class: " + nextClassname);
            }
        }
        return beanClasses;
    }
}

