/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.websocket.api.Conversation;
import org.glassfish.websocket.api.ConversionException;
import org.glassfish.websocket.api.EndpointContext;
import org.glassfish.websocket.api.Peer;
import org.glassfish.websocket.api.TextEncoder;
import org.glassfish.websocket.platform.EndpointContextImpl;
import org.glassfish.websocket.platform.WebSocketConversationImpl;
import org.glassfish.websocket.platform.WebSocketEndpoint;

public class WebSocketWrapper
implements Peer {
    private WebSocket grizzlySocket;
    private WebSocketConversationImpl webSocketSession;
    private EndpointContextImpl webSocketContext;
    private String clientAddress;
    Date activationTime = new Date();
    private static Set<WebSocketWrapper> wsws = new HashSet<WebSocketWrapper>();
    static final Logger logger = Logger.getLogger("wsplatform");

    public static WebSocketWrapper getWebSocketWrapper(WebSocket socket, WebSocketEndpoint application) {
        String remoteImpl = application.getRemoteImplClassname();
        WebSocketWrapper wsw = null;
        if (WebSocketWrapper.findWebSocketWrapper(socket) != null) {
            wsw = WebSocketWrapper.findWebSocketWrapper(socket);
            if (!wsw.getClass().getCanonicalName().equals(remoteImpl)) {
                throw new RuntimeException("Should not get here. You are asking for a remote impl :" + remoteImpl + ": of a different type from one I already have :" + wsw.getClass().getCanonicalName() + ": !");
            }
        } else {
            if (remoteImpl.equals(WebSocketWrapper.class.getCanonicalName())) {
                wsw = new WebSocketWrapper();
            } else {
                try {
                    Class<?> c = application.getClass().getClassLoader().loadClass(remoteImpl);
                    wsw = (WebSocketWrapper)c.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate a " + remoteImpl);
                }
            }
            wsw.grizzlySocket = socket;
            wsw.webSocketSession = new WebSocketConversationImpl(wsw);
            wsw.webSocketContext = application.getEndpointContext();
            wsw.webSocketContext.addWebSocketSession(wsw.webSocketSession);
            wsws.add(wsw);
        }
        return wsw;
    }

    private static Set<WebSocketWrapper> getWebSocketWrappers() {
        WebSocketWrapper.weedExpiredWebSocketWrappers();
        return wsws;
    }

    private static void weedExpiredWebSocketWrappers() {
        HashSet<WebSocketWrapper> expired = new HashSet<WebSocketWrapper>();
        for (WebSocketWrapper wsw : wsws) {
            if (wsw.isConnected()) continue;
            expired.add(wsw);
        }
        for (WebSocketWrapper toRemove : expired) {
            wsws.remove(toRemove);
        }
    }

    static WebSocketWrapper findWebSocketWrapper(WebSocket socket) {
        for (WebSocketWrapper nextWsw : WebSocketWrapper.getWebSocketWrappers()) {
            if (nextWsw.grizzlySocket != socket) continue;
            return nextWsw;
        }
        return null;
    }

    protected WebSocketWrapper() {
    }

    @Override
    public String getAddress() {
        return this.clientAddress;
    }

    void setAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    @Override
    public EndpointContext getContext() {
        return this.webSocketContext;
    }

    @Override
    public Conversation getConversation() {
        return this.webSocketSession;
    }

    @Override
    public boolean isConnected() {
        return this.grizzlySocket.isConnected();
    }

    private boolean isPrimitiveData(Object data) {
        Class<?> dataClass = data.getClass();
        boolean isPrimitive = dataClass.equals(Integer.class) || dataClass.equals(Byte.class) || dataClass.equals(Short.class) || dataClass.equals(Long.class) || dataClass.equals(Float.class) || dataClass.equals(Double.class) || dataClass.equals(Boolean.class) || dataClass.equals(Character.class);
        return isPrimitive;
    }

    public void sendPrimitiveMessage(Object data) throws IOException, ConversionException {
        if (!this.isPrimitiveData(data)) {
            throw new ConversionException("object " + data + " is not a primitive type.");
        }
        this.sendMessage(data.toString());
    }

    public void sendPolymorphic(Object o, String[] encoderClassnames) throws IOException, ConversionException {
        if (o instanceof String) {
            this.sendMessage((String)o);
            return;
        }
        List<String> encoders = Arrays.asList(encoderClassnames);
        for (String encoder : encoderClassnames) {
            try {
                Class<?> c = this.webSocketContext.getBeanClassloader().loadClass(encoder);
                List<Class<?>> interfaces = Arrays.asList(c.getInterfaces());
                if (!interfaces.contains(TextEncoder.class)) continue;
                Method m = null;
                try {
                    m = c.getMethod("encode", o.getClass());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (m == null) continue;
                TextEncoder te = (TextEncoder)c.newInstance();
                String toSendString = te.encode(o);
                this.sendMessage(toSendString);
                return;
            }
            catch (ConversionException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage() + " :Could not send message object " + o + " which is of type " + o.getClass() + " with encoders " + encoderClassnames);
            }
        }
        if (this.isPrimitiveData(o)) {
            this.sendPrimitiveMessage(o);
            return;
        }
        throw new RuntimeException("Could not send message object " + o + " which is of type " + o.getClass() + " with encoders " + encoders);
    }

    WebSocket getSocket() {
        return this.grizzlySocket;
    }

    @Override
    public void sendMessage(String data) throws IOException {
        this.grizzlySocket.send(data);
    }

    @Override
    public void sendMessage(byte[] data) throws IOException {
        this.grizzlySocket.send(data);
    }

    public void doNothing() throws ConversionException {
    }

    public String toString() {
        return "WSW: " + this.getClass().getSimpleName();
    }

    @Override
    public void doClose(int code, String reason) throws IOException {
        this.grizzlySocket.close(code, reason);
    }
}

