/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform;

import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.websocket.api.Peer;
import org.glassfish.websocket.api.WSEndpoint;
import org.glassfish.websocket.platform.WebSocketEndpoint;
import org.glassfish.websocket.platform.WebSocketWrapper;

public class WebSocketEndpointAdapter
extends WebSocketEndpoint {
    private WSEndpoint endpoint;

    WebSocketEndpointAdapter(WSEndpoint endpoint, String path) {
        this.endpoint = endpoint;
        this.path = path;
    }

    void init() {
        this.endpoint.initialize(super.getEndpointContext());
    }

    @Override
    public void onConnect(WebSocket socket) {
        super.onConnect(socket);
        WebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);
        this.endpoint.onOpen(wsw);
    }

    @Override
    public void onMessage(WebSocket socket, String messageString) {
        WebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);
        this.endpoint.onMessage((Peer)wsw, messageString);
    }

    @Override
    public void onMessage(WebSocket socket, byte[] data) {
        WebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);
        this.endpoint.onMessage((Peer)wsw, data);
    }

    @Override
    public void onClose(WebSocket socket) {
        super.onClose(socket);
        WebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);
        this.endpoint.onClose(wsw, null);
    }

    @Override
    public void remove() {
        this.endpoint.remove();
    }
}

