/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.websocket.api.ConversionException;
import org.glassfish.websocket.api.TextDecoder;
import org.glassfish.websocket.api.TextEncoder;
import org.glassfish.websocket.platform.BeanServer;
import org.glassfish.websocket.platform.ContainerContextImpl;
import org.glassfish.websocket.platform.EndpointContextImpl;
import org.glassfish.websocket.platform.WebSocketConversationImpl;
import org.glassfish.websocket.platform.WebSocketWrapper;
import org.glassfish.websocket.platform.decoders.BooleanDecoder;
import org.glassfish.websocket.platform.decoders.CharDecoder;
import org.glassfish.websocket.platform.decoders.DoubleDecoder;
import org.glassfish.websocket.platform.decoders.FloatDecoder;
import org.glassfish.websocket.platform.decoders.IntegerDecoder;
import org.glassfish.websocket.platform.decoders.LongDecoder;
import org.glassfish.websocket.platform.decoders.ShortDecoder;
import org.glassfish.websocket.platform.decoders.StringDecoderNoOp;
import org.glassfish.websocket.platform.encoders.BooleanEncoder;
import org.glassfish.websocket.platform.encoders.ByteEncoder;
import org.glassfish.websocket.platform.encoders.CharEncoder;
import org.glassfish.websocket.platform.encoders.DoubleEncoder;
import org.glassfish.websocket.platform.encoders.FloatEncoder;
import org.glassfish.websocket.platform.encoders.IntEncoder;
import org.glassfish.websocket.platform.encoders.LongEncoder;
import org.glassfish.websocket.platform.encoders.ShortEncoder;
import org.glassfish.websocket.platform.encoders.StringEncoderNoOp;

public abstract class WebSocketEndpoint
extends WebSocketApplication {
    protected String path;
    protected String remoteImplClassname = WebSocketWrapper.class.getCanonicalName();
    protected Set decoders;
    protected Set encoders;
    protected List allDecoders;
    protected List allEncoders;
    protected EndpointContextImpl endpointContext;
    protected HttpSession httpSessionForNextOnConnect = null;
    private String originAddressForNextOnConnect = null;
    protected String fullPathForNextOnConnect = "";
    protected List supportedSubprotocols = new ArrayList();

    public WebSocketEndpoint() {
        this.endpointContext = new EndpointContextImpl(BeanServer.getContainerContext(), this);
    }

    protected boolean doesPathMatch(String dynamicPath) {
        if (dynamicPath.equals("*")) {
            return true;
        }
        return (this.path + dynamicPath).equals(this.fullPathForNextOnConnect);
    }

    protected String getPathSegment() {
        return this.fullPathForNextOnConnect.substring(this.path.length(), this.fullPathForNextOnConnect.length());
    }

    private void initAllEncoders() {
        if (this.allEncoders == null) {
            this.allEncoders = new ArrayList();
            this.allEncoders.addAll(this.encoders);
            this.allEncoders.add(StringEncoderNoOp.class);
            this.allEncoders.add(BooleanEncoder.class);
            this.allEncoders.add(ByteEncoder.class);
            this.allEncoders.add(CharEncoder.class);
            this.allEncoders.add(DoubleEncoder.class);
            this.allEncoders.add(FloatEncoder.class);
            this.allEncoders.add(IntEncoder.class);
            this.allEncoders.add(LongEncoder.class);
            this.allEncoders.add(ShortEncoder.class);
        }
    }

    private void initAllDecoders() {
        if (this.allDecoders == null) {
            this.allDecoders = new ArrayList();
            this.allDecoders.addAll(this.decoders);
            this.allDecoders.add(StringDecoderNoOp.class);
            this.allDecoders.add(BooleanDecoder.class);
            this.allDecoders.add(IntegerDecoder.class);
            this.allDecoders.add(LongDecoder.class);
            this.allDecoders.add(ShortDecoder.class);
            this.allDecoders.add(FloatDecoder.class);
            this.allDecoders.add(DoubleDecoder.class);
            this.allDecoders.add(CharDecoder.class);
        }
    }

    public static String getClassTypeForTypeThatMightBePrimitive(String possiblyPrimitiveType) {
        String type2 = possiblyPrimitiveType;
        if (possiblyPrimitiveType.equals("boolean")) {
            type2 = "java.lang.Boolean";
        } else if (possiblyPrimitiveType.equals("char")) {
            type2 = "java.lang.Character";
        } else if (possiblyPrimitiveType.equals("double")) {
            type2 = "java.lang.Double";
        } else if (possiblyPrimitiveType.equals("float")) {
            type2 = "java.lang.Float";
        } else if (possiblyPrimitiveType.equals("int")) {
            type2 = "java.lang.Integer";
        } else if (possiblyPrimitiveType.equals("long")) {
            type2 = "java.lang.Long";
        } else if (possiblyPrimitiveType.equals("short")) {
            type2 = "java.lang.Short";
        }
        return type2;
    }

    public Constructor getStringConstructor(Class c) throws Exception {
        Constructor<?>[] constructors = c.getConstructors();
        for (Constructor<?> nextConstructor : c.getConstructors()) {
            if (nextConstructor.getParameterTypes().length != 1 || !nextConstructor.getParameterTypes()[0].equals(String.class)) continue;
            return nextConstructor;
        }
        return null;
    }

    public Method getFactoryMethodWithStringParameter(Class c) throws Exception {
        for (Method m : c.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !m.getReturnType().equals(c) || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].equals(String.class)) continue;
            return m;
        }
        return null;
    }

    public Object doDecode(String message, String possiblyPrimitiveType) throws ConversionException {
        this.initAllDecoders();
        String type2 = WebSocketEndpoint.getClassTypeForTypeThatMightBePrimitive(possiblyPrimitiveType);
        for (Object next : this.allDecoders) {
            Class nextClass = (Class)next;
            List<Class<?>> interfaces = Arrays.asList(nextClass.getInterfaces());
            if (!interfaces.contains(TextDecoder.class)) continue;
            try {
                TextDecoder decoder;
                boolean willItDecode;
                Method m = nextClass.getDeclaredMethod("decode", String.class);
                Class<?> returnC = m.getReturnType();
                Class<?> proposedType = this.endpointContext.getBeanClassloader().loadClass(type2);
                if (!proposedType.equals(returnC) || !(willItDecode = (decoder = (TextDecoder)nextClass.newInstance()).willDecode(message))) continue;
                return decoder.decode(message);
            }
            catch (ConversionException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String doEncode(Object o) throws ConversionException {
        this.initAllEncoders();
        for (Object next : this.allEncoders) {
            Class<?> type2 = o.getClass();
            Class nextClass = (Class)next;
            List<Class<?>> interfaces = Arrays.asList(nextClass.getInterfaces());
            if (!interfaces.contains(TextEncoder.class)) continue;
            try {
                Method m = nextClass.getMethod("encode", o.getClass());
                if (m == null) continue;
                TextEncoder te = (TextEncoder)nextClass.newInstance();
                String returnString = te.encode(o);
                return returnString;
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (ConversionException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unable to encode " + o);
    }

    String getPath() {
        return this.path;
    }

    EndpointContextImpl getEndpointContext() {
        return this.endpointContext;
    }

    String getRemoteImplClassname() {
        return this.remoteImplClassname;
    }

    @Override
    public boolean isApplicationRequest(HttpRequestPacket o) {
        boolean match = o.getRequestURI().startsWith(this.path);
        this.httpSessionForNextOnConnect = this.getHttpSession(o);
        this.originAddressForNextOnConnect = o.getHeader("Origin");
        this.fullPathForNextOnConnect = match ? o.getRequestURI() : "";
        return match;
    }

    @Override
    public List<String> getSupportedProtocols(List<String> subProtocol) {
        ArrayList<String> supported = new ArrayList<String>();
        for (String nextRequestedProtocolName : subProtocol) {
            if (!this.supportedSubprotocols.contains(nextRequestedProtocolName)) continue;
            supported.add(nextRequestedProtocolName);
        }
        return supported;
    }

    protected void addSupportedSubprotocol(String subprotocol) {
        this.supportedSubprotocols.add(subprotocol);
    }

    @Override
    public void onConnect(WebSocket socket) {
        WebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);
        if (wsw == null) {
            throw new RuntimeException("XCouldn't find web socket wrapper for this socket for " + this.remoteImplClassname);
        }
        wsw.setAddress(this.originAddressForNextOnConnect);
        if (ContainerContextImpl.WEB_MODE && this.httpSessionForNextOnConnect != null) {
            ((WebSocketConversationImpl)wsw.getConversation()).setHttpSession(this.httpSessionForNextOnConnect);
            this.httpSessionForNextOnConnect = null;
        }
    }

    public void onClose(WebSocket socket) {
        throw new RuntimeException("I got closed...");
    }

    public HttpSession getHttpSession(HttpRequestPacket o) {
        return null;
    }

    public void remove() {
    }
}

