/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpSession;
import org.glassfish.websocket.api.Conversation;
import org.glassfish.websocket.api.Peer;
import org.glassfish.websocket.platform.WebSocketWrapper;
import org.glassfish.websocket.platform.WithProperties;

public class WebSocketConversationImpl
extends WithProperties
implements Conversation<Peer> {
    private WebSocketWrapper wsw;
    private long conversationID;
    static long count = 0L;
    private HttpSession httpSession;

    WebSocketConversationImpl(WebSocketWrapper wsw) {
        this.wsw = wsw;
        this.conversationID = count++;
    }

    void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    @Override
    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    @Override
    public String getSubprotocol() {
        return "not implemented";
    }

    @Override
    public Peer getPeer() {
        return this.wsw;
    }

    @Override
    public Long getConversationID() {
        return new Long(count);
    }

    @Override
    public boolean isActive() {
        return this.wsw.isConnected();
    }

    @Override
    public Date getActivationTime() {
        return this.wsw.activationTime;
    }

    @Override
    public void deactivate(int code, String reason) throws IOException {
        this.wsw.doClose(code, reason);
    }

    public String toString() {
        return "Session(" + this.conversationID + ", " + this.isActive() + ")";
    }
}

