/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform;

import java.util.HashSet;
import java.util.Set;
import org.glassfish.websocket.api.ContainerContext;
import org.glassfish.websocket.api.Conversation;
import org.glassfish.websocket.api.EndpointContext;
import org.glassfish.websocket.platform.ContainerContextImpl;
import org.glassfish.websocket.platform.WebSocketConversationImpl;
import org.glassfish.websocket.platform.WebSocketEndpoint;
import org.glassfish.websocket.platform.WithProperties;

public class EndpointContextImpl
extends WithProperties
implements EndpointContext {
    private Set<Conversation> webSocketSessions = new HashSet<Conversation>();
    private ContainerContextImpl containerContext;
    private WebSocketEndpoint application;

    @Override
    public String getPath() {
        return this.application.path;
    }

    public ClassLoader getBeanClassloader() {
        return this.application.getClass().getClassLoader();
    }

    public EndpointContextImpl(ContainerContextImpl containerContext, WebSocketEndpoint application) {
        this.containerContext = containerContext;
        this.application = application;
    }

    @Override
    public String getProtocol() {
        return "ws";
    }

    @Override
    public Set<Conversation> getConversations() {
        this.weedExpiredSessions();
        return this.webSocketSessions;
    }

    @Override
    public ContainerContext getContainerContext() {
        return this.containerContext;
    }

    private void weedExpiredSessions() {
        HashSet<Conversation> expired = new HashSet<Conversation>();
        for (Conversation conversation : this.webSocketSessions) {
            if (conversation.isActive()) continue;
            expired.add(conversation);
        }
        for (Conversation<Object> conversation : expired) {
            this.webSocketSessions.remove(conversation);
        }
    }

    void addWebSocketSession(WebSocketConversationImpl webSocketSession) {
        this.webSocketSessions.add(webSocketSession);
    }

    public String toXString() {
        return "WebSocketContext(" + this.getPath() + ")";
    }
}

