/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.websocket.api.Peer;

class ConversationImpl {
    private Set<Peer> remotes = new HashSet<Peer>();
    private WebSocket socket;
    private Long id;
    private Map properties = new HashMap();
    private boolean isValid = true;
    private HttpSession httpSession;

    ConversationImpl(WebSocket socket, Long id, HttpSession httpSession) {
        this.socket = socket;
        this.id = id;
        this.httpSession = httpSession;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public boolean isValid() {
        if (!this.socket.isConnected()) {
            this.isValid = false;
        }
        return this.isValid;
    }

    public void expire() throws IOException {
        this.socket.close();
        this.properties = new HashMap();
        this.setValid(false);
    }

    void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Long getSessionID() {
        return this.id;
    }

    public Set<Peer> getRemotes() {
        return this.remotes;
    }

    public Peer getRemote(Class c) {
        for (Peer nextRemote : this.remotes) {
            Class<?>[] interfaces;
            if (nextRemote.getClass().equals(c)) {
                return nextRemote;
            }
            for (Class<?> ifc : interfaces = nextRemote.getClass().getInterfaces()) {
                if (!ifc.equals(c)) continue;
                return nextRemote;
            }
        }
        return null;
    }

    public String toString() {
        return "Session" + this.id + "(" + this.remotes + ";" + this.properties + ")";
    }

    void addRemote(Peer remote) {
        this.remotes.add(remote);
    }

    WebSocket getWebSocket() {
        return this.socket;
    }
}

