/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.websocket.api.ContainerContext;
import org.glassfish.websocket.api.EndpointContext;
import org.glassfish.websocket.api.WSEndpoint;
import org.glassfish.websocket.platform.BeanServer;
import org.glassfish.websocket.platform.EndpointContextImpl;
import org.glassfish.websocket.platform.WebSocketEndpoint;
import org.glassfish.websocket.platform.WebSocketEndpointAdapter;
import org.glassfish.websocket.platform.WithProperties;

public class ContainerContextImpl
extends WithProperties
implements ContainerContext {
    static ContainerContextImpl instance;
    static boolean WEB_MODE;
    private String wsPath;
    private int port;
    private BeanServer beanServer;

    public ContainerContextImpl(BeanServer beanServer, String wsPath, int port) {
        this.wsPath = wsPath;
        this.port = port;
        this.beanServer = beanServer;
        instance = this;
    }

    public ContainerContextImpl() {
        if (instance != null) {
            this.wsPath = ContainerContextImpl.instance.wsPath;
            this.port = ContainerContextImpl.instance.port;
            this.beanServer = this.beanServer;
        }
    }

    @Override
    public String getPath() {
        return this.wsPath;
    }

    @Override
    public List<EndpointContext> getEndpointContexts() {
        ArrayList<EndpointContext> l = new ArrayList<EndpointContext>();
        for (WebSocketApplication application : this.beanServer.applications) {
            EndpointContextImpl wsc = ((WebSocketEndpoint)application).getEndpointContext();
            l.add(wsc);
        }
        return l;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void deploy(WSEndpoint endpoint, String path) {
        WebSocketEndpointAdapter adapter = new WebSocketEndpointAdapter(endpoint, path);
        adapter.init();
        this.beanServer.deploy(adapter);
    }

    public static void setWebMode(boolean b) {
        WEB_MODE = b;
    }

    public String toString() {
        return "ContainerContext(" + this.wsPath + ")";
    }

    static {
        WEB_MODE = true;
    }
}

