/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.websocket.api.annotations.WebSocket;
import org.glassfish.websocket.platform.ContainerContextImpl;
import org.glassfish.websocket.platform.Initable;
import org.glassfish.websocket.platform.WebSocketEndpoint;
import org.glassfish.websocket.platform.processors.WSProcessor;

public class BeanServer {
    static String hostname = "localhost";
    static final Logger logger = Logger.getLogger("wsplatform");
    List<WebSocketApplication> applications = new ArrayList<WebSocketApplication>();
    private static ContainerContextImpl containerContext;

    public static ContainerContextImpl getContainerContext() {
        return containerContext;
    }

    public void closeWebSocketServer() {
        for (WebSocketApplication wsa : this.applications) {
            ((WebSocketEndpoint)wsa).remove();
            WebSocketEngine.getEngine().unregister(wsa);
            logger.info("Closing down : " + wsa);
        }
    }

    public void initWebSocketServer(String wsPath, int port, Set<Class<?>> fqWSBeanNames) throws Exception {
        containerContext = new ContainerContextImpl(this, wsPath, port);
        for (Class<?> webSocketApplicationBeanClazz : fqWSBeanNames) {
            Object webSocketApplicationBean = webSocketApplicationBeanClazz.newInstance();
            Map<Method, String> methodPathMap = this.getMethodToPathMap(webSocketApplicationBeanClazz);
            if (methodPathMap.isEmpty()) {
                logger.warning(webSocketApplicationBeanClazz + " has no path mappings");
            }
            WebSocketApplication applicationBeanWrapper = null;
            HashSet<String> allPathsForBean = new HashSet<String>(methodPathMap.values());
            for (String nextPath : allPathsForBean) {
                String wrapperClassname = WSProcessor.getQualifiedClassnameFor(webSocketApplicationBeanClazz.getCanonicalName(), nextPath);
                Set allMethodsForPath = this.getMethodsForPath(webSocketApplicationBeanClazz, nextPath);
                Set allDecodersForBean = this.getDecodersForBean(webSocketApplicationBeanClazz);
                Set allEncodersForBean = this.getEncodersForBean(webSocketApplicationBeanClazz);
                Class<?> wrapperClass = webSocketApplicationBeanClazz.getClassLoader().loadClass(wrapperClassname);
                applicationBeanWrapper = (WebSocketApplication)wrapperClass.newInstance();
                String wrapperBeanPath = wsPath + nextPath;
                ((Initable)((Object)applicationBeanWrapper)).doInit(wrapperBeanPath, allDecodersForBean, allEncodersForBean, webSocketApplicationBean, allMethodsForPath);
                this.deploy(applicationBeanWrapper);
            }
        }
    }

    void deploy(WebSocketApplication wsa) {
        WebSocketEngine.getEngine().register(wsa);
        this.applications.add(wsa);
        logger.info("Registered a " + wsa.getClass() + " at " + ((WebSocketEndpoint)wsa).getPath());
    }

    private Set getMethodsForPath(Class beanClazz, String path) throws Exception {
        HashSet<Method> s = new HashSet<Method>();
        Map<Method, String> methodPath = this.getMethodToPathMap(beanClazz);
        for (Method m : methodPath.keySet()) {
            String p = methodPath.get(m);
            if (!p.equals(path)) continue;
            s.add(m);
        }
        return s;
    }

    private Set getEncodersForBean(Class beanClazz) throws Exception {
        HashSet<Class> encoders = new HashSet<Class>();
        WebSocket wsClass = beanClazz.getAnnotation(WebSocket.class);
        for (Class encoder : wsClass.encoders()) {
            encoders.add(encoder);
        }
        return encoders;
    }

    private Set getDecodersForBean(Class beanClazz) throws Exception {
        HashSet<Class> decoders = new HashSet<Class>();
        WebSocket wsClass = beanClazz.getAnnotation(WebSocket.class);
        for (Class decoder : wsClass.decoders()) {
            decoders.add(decoder);
        }
        return decoders;
    }

    private Map<Method, String> getMethodToPathMap(Class beanClazz) throws Exception {
        Method[] methods;
        HashMap<Method, String> pathMappings = new HashMap<Method, String>();
        for (Method method : methods = beanClazz.getDeclaredMethods()) {
            WebSocket wsClass = beanClazz.getAnnotation(WebSocket.class);
            pathMappings.put(method, wsClass.path());
        }
        return pathMappings;
    }
}

