/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.sniffer;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.GenericSniffer;
import org.glassfish.web.WarType;
import org.jvnet.hk2.annotations.Service;

@Service(name="web")
@Singleton
public class WebSniffer
extends GenericSniffer {
    @Inject
    WarType warType;
    @Inject
    ServiceLocator locator;
    private static final String[] containers = new String[]{"com.sun.enterprise.web.WebContainer"};
    private static final List<String> deploymentConfigurationPaths = WebSniffer.initDeploymentConfigurationPaths();
    private String[] containerModuleNames = new String[]{"org.glassfish.main.web.glue", "org.glassfish.web.javax.servlet.jsp", "org.glassfish.javax.el"};

    public WebSniffer() {
        super("web", "WEB-INF/web.xml", null);
    }

    @Override
    public String[] getURLPatterns() {
        return new String[]{"*.jsp", "*.jspx"};
    }

    @Override
    public boolean handles(DeploymentContext context) {
        ArchiveType archiveType = this.habitat.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        if (archiveType != null && !this.supportsArchiveType(archiveType)) {
            return false;
        }
        return DeploymentUtils.isArchiveOfType(context.getSource(), this.warType, context, this.locator);
    }

    @Override
    public boolean handles(ReadableArchive location) {
        return DeploymentUtils.isArchiveOfType(location, this.warType, this.locator);
    }

    @Override
    public String[] getContainersNames() {
        return containers;
    }

    @Override
    public boolean isUserVisible() {
        return true;
    }

    @Override
    public boolean isJavaEE() {
        return true;
    }

    private static List<String> initDeploymentConfigurationPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("WEB-INF/web.xml");
        result.add("WEB-INF/sun-web.xml");
        result.add("WEB-INF/glassfish-web.xml");
        result.add("WEB-INF/weblogic.xml");
        return result;
    }

    @Override
    protected List<String> getDeploymentConfigurationPaths() {
        return deploymentConfigurationPaths;
    }

    @Override
    public String[] getIncompatibleSnifferTypes() {
        return new String[]{"connector"};
    }

    @Override
    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.equals(this.warType);
    }

    @Override
    protected String[] getContainerModuleNames() {
        return this.containerModuleNames;
    }
}

