/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Session;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.ha.common.GlassFishHAReplicaPredictor;
import org.glassfish.ha.common.HACookieInfo;
import org.glassfish.ha.common.HACookieManager;
import org.glassfish.ha.common.NoopHAReplicaPredictor;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.web.ha.session.management.ReplicationManagerBase;
import org.glassfish.web.ha.session.management.ReplicationStore;
import org.glassfish.web.ha.session.management.WebEventPersistentManager;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class ReplicationWebEventPersistentManager<T extends Storeable>
extends ReplicationManagerBase<T>
implements WebEventPersistentManager {
    @Inject
    private ServiceLocator services;
    @Inject
    private GMSAdapterService gmsAdapterService;
    private GlassFishHAReplicaPredictor predictor;
    private String clusterName = "";
    private String instanceName = "";
    public static final String COULD_NOT_CREATE_BACKING_STORE = "AS-WEB-HA-00008";
    private static final String info = "ReplicationWebEventPersistentManager/1.0";
    private static final String name = "ReplicationWebEventPersistentManager";
    private static int _messageIDCounter = 0;

    @Override
    public String getInfo() {
        return info;
    }

    public ReplicationWebEventPersistentManager() {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("ReplicationWebEventPersistentManager created");
        }
    }

    @Override
    public void doValveSave(Session session) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("in doValveSave");
        }
        try {
            ReplicationStore replicationStore = (ReplicationStore)this.getStore();
            replicationStore.doValveSave(session);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("FINISHED repStore.valveSave");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._logger.log(Level.FINE, "exception occurred in doValveSave id=" + session.getIdInternal(), ex);
        }
    }

    @Override
    public void postRequestDispatcherProcess(ServletRequest request, ServletResponse response) {
        Session sess = this.getSession(request);
        if (sess != null) {
            this.doValveSave(sess);
        }
    }

    private Session getSession(ServletRequest request) {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpSession httpSess = httpReq.getSession(false);
        if (httpSess == null) {
            return null;
        }
        String id = httpSess.getId();
        Session sess = null;
        try {
            sess = this.findSession(id);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return sess;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    protected void processMaxIdleBackups() {
    }

    @Override
    protected void processMaxActiveSwaps() {
    }

    @Override
    protected void processMaxIdleSwaps() {
    }

    @Override
    public String getReplicaFromPredictor(String sessionId, String oldJreplicaValue) {
        if (this.isDisableJreplica()) {
            return null;
        }
        HACookieInfo cookieInfo = this.predictor.makeCookie(this.gmsAdapterService.getGMSAdapter().getClusterName(), sessionId, oldJreplicaValue);
        HACookieManager.setCurrrent(cookieInfo);
        return cookieInfo.getNewReplicaCookie();
    }

    @Override
    public void createBackingStore(String persistenceType, String storeName, Class<T> metadataClass, Map<String, Object> vendorMap) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("Create backing store invoked with persistence type " + persistenceType + " and store name " + storeName);
        }
        BackingStoreFactory factory = this.services.getService(BackingStoreFactory.class, persistenceType, new Annotation[0]);
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        if (this.gmsAdapterService.isGmsEnabled()) {
            this.clusterName = this.gmsAdapterService.getGMSAdapter().getClusterName();
            this.instanceName = this.gmsAdapterService.getGMSAdapter().getModule().getInstanceName();
        }
        conf.setStoreName(storeName).setClusterName(this.clusterName).setInstanceName(this.instanceName).setStoreType(persistenceType).setKeyClazz(String.class).setValueClazz(metadataClass).setClassLoader(this.getClass().getClassLoader());
        if (vendorMap != null) {
            conf.getVendorSpecificSettings().putAll(vendorMap);
        }
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("About to create backing store " + conf);
            }
            this.backingStore = factory.createBackingStore(conf);
        }
        catch (BackingStoreException e) {
            this._logger.log(Level.WARNING, COULD_NOT_CREATE_BACKING_STORE, e);
        }
        Object obj = conf.getVendorSpecificSettings().get("key.mapper");
        if (obj != null && obj instanceof GlassFishHAReplicaPredictor) {
            this.predictor = (GlassFishHAReplicaPredictor)obj;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("ReplicatedManager.keymapper is " + this.predictor);
            }
        } else {
            this.predictor = new NoopHAReplicaPredictor();
        }
    }
}

