/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import java.security.Principal;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntry;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;
import org.glassfish.web.ha.session.management.HAStoreBase;

public class HASingleSignOn
extends GlassFishSingleSignOn {
    private static final Logger logger = HAStoreBase._logger;
    private BackingStore<String, HASingleSignOnEntryMetadata> ssoEntryMetadataBackingStore = null;
    private JavaEEIOUtils ioUtils = null;

    public HASingleSignOn(JavaEEIOUtils ioUtils, BackingStore<String, HASingleSignOnEntryMetadata> ssoEntryMetadataBackingStore) {
        this.ioUtils = ioUtils;
        this.ssoEntryMetadataBackingStore = ssoEntryMetadataBackingStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deregister(String ssoId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deregistering sso id '" + ssoId + "'");
        }
        SingleSignOnEntry sso = null;
        Map map = this.cache;
        synchronized (map) {
            sso = (SingleSignOnEntry)this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        sso.expireSessions();
        try {
            this.ssoEntryMetadataBackingStore.remove(ssoId);
        }
        catch (BackingStoreException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void register(String ssoId, Principal principal, String authType, String username, char[] password, String realmName) {
        if (this.debug >= 1) {
            this.log("Registering sso id '" + ssoId + "' for user '" + principal.getName() + "' with auth type '" + authType + "'");
        }
        HASingleSignOnEntry ssoEntry = null;
        Map map = this.cache;
        synchronized (map) {
            ssoEntry = new HASingleSignOnEntry(ssoId, principal, authType, username, realmName, System.currentTimeMillis(), 1000000L, 0L, this.ioUtils);
            this.cache.put(ssoId, ssoEntry);
        }
        try {
            this.ssoEntryMetadataBackingStore.save(ssoId, ssoEntry.getMetadata(), true);
        }
        catch (BackingStoreException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void associate(String ssoId, long ssoVersion, Session session) {
        HASingleSignOnEntry sso;
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log("Associate sso id " + ssoId + " with session " + session);
        }
        if ((sso = (HASingleSignOnEntry)this.lookup(ssoId, ssoVersion)) != null) {
            session.setSsoId(ssoId);
            sso.addSession(this, session);
            try {
                this.ssoEntryMetadataBackingStore.save(ssoId, sso.getMetadata(), false);
            }
            catch (BackingStoreException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SingleSignOnEntry lookup(String ssoId, long ssoVersion) {
        SingleSignOnEntry ssoEntry = super.lookup(ssoId, ssoVersion);
        if (ssoEntry != null && ssoVersion > ssoEntry.getVersion()) {
            Map map = this.cache;
            synchronized (map) {
                this.cache.remove(ssoId);
            }
            ssoEntry = null;
        }
        if (ssoEntry == null) {
            try {
                HASingleSignOnEntryMetadata mdata = this.ssoEntryMetadataBackingStore.load(ssoId, null);
                if (mdata != null) {
                    ssoEntry = new HASingleSignOnEntry(this.getContainer(), mdata, this.ioUtils);
                    this.cache.put(ssoId, ssoEntry);
                }
            }
            catch (BackingStoreException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return ssoEntry;
    }

    @Override
    protected void removeSession(String ssoId, Session session) {
        HASingleSignOnEntry entry;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing session " + session.toString() + " from sso id " + ssoId);
        }
        if ((entry = (HASingleSignOnEntry)this.lookup(ssoId)) == null) {
            return;
        }
        entry.removeSession(session);
        if (entry.isEmpty()) {
            this.deregister(ssoId);
        } else {
            try {
                this.ssoEntryMetadataBackingStore.save(ssoId, entry.getMetadata(), false);
            }
            catch (BackingStoreException ex) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isVersioningSupported() {
        return true;
    }
}

