/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.glassfish.web.deployment.node.AbsoluteOrderingNode;
import org.glassfish.web.deployment.node.WebCommonNode;
import org.w3c.dom.Node;

public class WebBundleNode
extends WebCommonNode<WebBundleDescriptorImpl> {
    public static final XMLElement tag = new XMLElement("web-app");
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    public static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/web-app_2_3.dtd";
    public static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/web-app_2_2.dtd";
    public static final String SCHEMA_ID_24 = "web-app_2_4.xsd";
    public static final String SCHEMA_ID_25 = "web-app_2_5.xsd";
    public static final String SCHEMA_ID = "web-app_3_0.xsd";
    private static final List<String> systemIDs = WebBundleNode.initSystemIDs();

    private static List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        systemIDs.add(SCHEMA_ID_24);
        systemIDs.add(SCHEMA_ID_25);
        return Collections.unmodifiableList(systemIDs);
    }

    @Override
    public String registerBundle(Map<String, String> publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    @Override
    public Map<String, Class> registerRuntimeBundle(Map<String, String> publicIDToDTD, Map<String, List<Class>> versionUpgrades) {
        HashMap<String, Class> result = new HashMap<String, Class>();
        for (ConfigurationDeploymentDescriptorFile wddFile : DOLUtils.getConfigurationDeploymentDescriptorFiles(this.habitat, "war")) {
            wddFile.registerBundle(result, publicIDToDTD, versionUpgrades);
        }
        return result;
    }

    @Override
    public Collection<String> elementsAllowingEmptyValue() {
        HashSet<String> result = new HashSet<String>();
        result.add("load-on-startup");
        return result;
    }

    @Override
    public Collection<String> elementsPreservingWhiteSpace() {
        HashSet<String> result = new HashSet<String>();
        result.add("url-pattern");
        return result;
    }

    public WebBundleNode() {
        this.registerElementHandler(new XMLElement("absolute-ordering"), AbsoluteOrderingNode.class, "setAbsoluteOrderingDescriptor");
        SaxParserHandler.registerBundleNode(this, "web-app");
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("module-name".equals(element.getQName())) {
            WebBundleDescriptorImpl bundleDesc = this.getDescriptor();
            bundleDesc.getModuleDescriptor().setModuleName(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public WebBundleDescriptorImpl getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new WebBundleDescriptorImpl();
        }
        return this.descriptor;
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return tag;
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    public Node writeDescriptor(Node parent, WebBundleDescriptorImpl webBundleDesc) {
        Node jarNode = super.writeDescriptor(parent, webBundleDesc);
        if (webBundleDesc.getAbsoluteOrderingDescriptor() != null) {
            AbsoluteOrderingNode absOrderingNode = new AbsoluteOrderingNode();
            absOrderingNode.writeDescriptor(jarNode, "absolute-ordering", webBundleDesc.getAbsoluteOrderingDescriptor());
        }
        return jarNode;
    }
}

