/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Set;
import java.util.TreeSet;
import org.glassfish.deployment.common.Descriptor;

public class OrderingOrderingDescriptor
extends Descriptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(OrderingOrderingDescriptor.class);
    private Set<String> names = new TreeSet<String>();
    private boolean others = false;

    public void addName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptioninvalidnameinrelativeordering", "The empty name is invalid for relative ordering element."));
        }
        this.names.add(name);
    }

    public void addOthers() {
        this.others = true;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public boolean containsOthers() {
        return this.others;
    }

    public boolean containsName(String name) {
        return this.names.contains(name);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (String n : this.names) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(n);
            first = false;
        }
        if (this.others) {
            if (!first) {
                builder.append(", ");
            }
            builder.append("<others/>");
        }
        builder.append("]");
        return builder.toString();
    }
}

