/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.config;

import com.sun.enterprise.admin.commands.CreateSsl;
import com.sun.enterprise.admin.commands.DeleteSsl;
import com.sun.enterprise.admin.commands.SslConfigHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Ssl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="http-listener")
public class WebSslConfigHandler
implements SslConfigHandler {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateSsl.class);

    @Override
    public void create(final CreateSsl command, ActionReport report) {
        NetworkConfig netConfig = command.config.getNetworkConfig();
        NetworkListener listener = netConfig.getNetworkListener(command.listenerId);
        try {
            Protocol httpProtocol;
            if (listener == null) {
                report.setMessage(localStrings.getLocalString("create.ssl.http.notfound", "Network Listener named {0} does not exist.  Creating or using the named protocol element instead.", command.listenerId));
                httpProtocol = command.findOrCreateProtocol(command.listenerId);
            } else {
                httpProtocol = listener.findHttpProtocol();
                Ssl ssl = httpProtocol.getSsl();
                if (ssl != null) {
                    report.setMessage(localStrings.getLocalString("create.ssl.http.alreadyExists", "Network Listener named {0} to which this ssl element is being added already has an ssl element.", command.listenerId));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) throws TransactionFailure {
                    Ssl newSsl = param.createChild(Ssl.class);
                    command.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, httpProtocol);
        }
        catch (TransactionFailure e) {
            command.reportError(report, e);
        }
        command.reportSuccess(report);
    }

    @Override
    public void delete(DeleteSsl command, ActionReport report) {
        NetworkConfig netConfig = command.config.getNetworkConfig();
        NetworkListener networkListener = netConfig.getNetworkListener(command.listenerId);
        if (networkListener == null) {
            report.setMessage(localStrings.getLocalString("delete.ssl.http.listener.notfound", "HTTP Listener named {0} not found", command.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Protocol protocol = networkListener.findHttpProtocol();
        if (protocol.getSsl() == null) {
            report.setMessage(localStrings.getLocalString("delete.ssl.element.doesnotexist", "Ssl element does not exist for Listener named {0}", command.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) {
                    param.setSsl(null);
                    return null;
                }
            }, networkListener.findHttpProtocol());
        }
        catch (TransactionFailure e) {
            command.reportError(report, e);
        }
    }
}

