/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.statistics;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AltServletStatsImpl
implements MonitorContract {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AltServletStatsImpl.class);
    private final String name = "servlet";
    private final String displayFormat = "%1$-10s %2$-10s %3$-10s";

    @Override
    public String getName() {
        return "servlet";
    }

    @Override
    public ActionReport process(ActionReport report, String filter) {
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry is null"));
            return report;
        }
        TreeNode serverNode = this.mrdr.get("server");
        if (serverNode == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry server node is null"));
            return report;
        }
        String[] patternArr = new String[]{"server.web.servlet.*"};
        long activeServletsLoadedCount = 0L;
        long maxServletsLoadedCount = 0L;
        long totalServletsLoadedCount = 0L;
        for (String pattern : patternArr) {
            List<TreeNode> tnL = serverNode.getNodes(pattern);
            for (TreeNode tn : tnL) {
                if (tn.hasChildNodes()) continue;
                if ("activeservletsloadedcount".equals(tn.getName())) {
                    activeServletsLoadedCount = this.getRangeStatisticValue(tn.getValue());
                    continue;
                }
                if ("maxservletsloadedcount".equals(tn.getName())) {
                    maxServletsLoadedCount = this.getCountStatisticValue(tn.getValue());
                    continue;
                }
                if (!"totalservletsloadedcount".equals(tn.getName())) continue;
                totalServletsLoadedCount = this.getCountStatisticValue(tn.getValue());
            }
        }
        report.setMessage(String.format("%1$-10s %2$-10s %3$-10s", activeServletsLoadedCount, maxServletsLoadedCount, totalServletsLoadedCount));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    private long getCountStatisticValue(Object obj) {
        long l = 0L;
        if (obj == null) {
            return l;
        }
        if (obj instanceof CountStatistic) {
            return ((CountStatistic)obj).getCount();
        }
        return l;
    }

    private long getRangeStatisticValue(Object obj) {
        long l = 0L;
        if (obj == null) {
            return l;
        }
        if (obj instanceof RangeStatistic) {
            return ((RangeStatistic)obj).getCurrent();
        }
        return l;
    }
}

