/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.cli.CreateHttp;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http-redirect")
@PerLookup
@I18n(value="delete.http.redirect")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.DELETE, path="delete-http-redirect", description="delete-http-redirect"), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.DELETE, path="delete-http-redirect", description="delete-http-redirect")})
public class DeleteHttpRedirect
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHttp.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;

    @Override
    public void execute(AdminCommandContext context) {
        Target targetUtil = this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        Protocol protocolToBeRemoved = null;
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        try {
            for (Protocol protocol : protocols.getProtocol()) {
                if (!this.protocolName.equalsIgnoreCase(protocol.getName())) continue;
                protocolToBeRemoved = protocol;
            }
            if (protocolToBeRemoved == null) {
                report.setMessage(localStrings.getLocalString("delete.http.notexists", "{0} http doesn't exist", this.protocolName));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            List<NetworkListener> nwlsnrList = protocolToBeRemoved.findNetworkListeners();
            for (NetworkListener nwlsnr : nwlsnrList) {
                if (!protocolToBeRemoved.getName().equals(nwlsnr.getProtocol())) continue;
                report.setMessage(localStrings.getLocalString("delete.protocol.beingused", "{0} protocol is being used in the network listener {1}", this.protocolName, nwlsnr.getName()));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) {
                    param.setHttpRedirect(null);
                    return null;
                }
            }, protocolToBeRemoved);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.http.fail", "Deletion of http {0} failed", this.protocolName) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

