/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolFinder;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-network-listener")
@PerLookup
@I18n(value="create.network.listener")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateNetworkListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateNetworkListener.class);
    @Param(name="address", optional=true)
    String address;
    @Param(name="listenerport", optional=false, alias="Port")
    String port;
    @Param(name="threadpool", optional=true, defaultValue="http-thread-pool", alias="threadPool")
    String threadPool;
    @Param(name="protocol", optional=false)
    String protocol;
    @Param(name="name", primary=true)
    String listenerName;
    @Param(name="transport", optional=true, defaultValue="tcp")
    String transport;
    @Param(name="enabled", optional=true, defaultValue="true")
    Boolean enabled;
    @Param(name="jkenabled", optional=true, defaultValue="false", alias="jkEnabled")
    Boolean jkEnabled;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServiceLocator services;
    @Inject
    Domain domain;

    @Override
    public void execute(AdminCommandContext context) {
        Target targetUtil = this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        NetworkListeners nls = networkConfig.getNetworkListeners();
        for (NetworkListener networkListener : nls.getNetworkListener()) {
            if (!networkListener.getName().equals(this.listenerName)) continue;
            report.setMessage(localStrings.getLocalString("create.network.listener.fail.duplicate", "Network Listener named {0} already exists.", this.listenerName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.verifyUniquePort(networkConfig)) {
            report.setMessage(localStrings.getLocalString("port.in.use", "Port [{0}] is already taken for address [{1}], please choose another port.", this.port, this.address));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Protocol prot = networkConfig.findProtocol(this.protocol);
        if (prot == null) {
            report.setMessage(localStrings.getLocalString("create.http.fail.protocolnotfound", "The specified protocol {0} is not yet configured", this.protocol));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (prot.getHttp() == null && prot.getPortUnification() == null) {
            report.setMessage(localStrings.getLocalString("create.network.listener.fail.bad.protocol", "Protocol {0} has neither a protocol nor a port-unification configured", this.protocol));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new ConfigCode(){

                @Override
                public Object run(ConfigBeanProxy ... params) throws TransactionFailure, PropertyVetoException {
                    NetworkListeners listeners = (NetworkListeners)params[0];
                    NetworkListener newNetworkListener = listeners.createChild(NetworkListener.class);
                    newNetworkListener.setProtocol(CreateNetworkListener.this.protocol);
                    newNetworkListener.setTransport(CreateNetworkListener.this.transport);
                    newNetworkListener.setEnabled(CreateNetworkListener.this.enabled.toString());
                    newNetworkListener.setJkEnabled(CreateNetworkListener.this.jkEnabled.toString());
                    newNetworkListener.setPort(CreateNetworkListener.this.port);
                    newNetworkListener.setThreadPool(CreateNetworkListener.this.threadPool);
                    newNetworkListener.setName(CreateNetworkListener.this.listenerName);
                    newNetworkListener.setAddress(CreateNetworkListener.this.address);
                    listeners.getNetworkListener().add(newNetworkListener);
                    ((VirtualServer)params[1]).addNetworkListener(CreateNetworkListener.this.listenerName);
                    return newNetworkListener;
                }
            }, nls, this.findVirtualServer(prot));
        }
        catch (TransactionFailure e) {
            e.printStackTrace();
            report.setMessage(localStrings.getLocalString("create.network.listener.fail", "{0} create failed: " + (e.getMessage() == null ? "No reason given" : e.getMessage()), this.listenerName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private VirtualServer findVirtualServer(Protocol protocol) {
        String name = null;
        Http http = protocol.getHttp();
        if (http != null) {
            name = http.getDefaultVirtualServer();
        } else {
            List<ProtocolFinder> finders = protocol.getPortUnification().getProtocolFinder();
            for (ProtocolFinder finder : finders) {
                Protocol p;
                if (name != null || (p = finder.findProtocol()).getHttp() == null) continue;
                name = p.getHttp().getDefaultVirtualServer();
            }
        }
        return this.config.getHttpService().getVirtualServerByName(name);
    }

    private boolean verifyUniquePort(NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getPort().trim().equals(this.port) || !listener.getAddress().trim().equals(this.address)) continue;
            return false;
        }
        return true;
    }
}

