/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.grizzly;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.websocket.ClientEndpointConfiguration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.tyrus.grizzly.GrizzlyClientSocket;
import org.glassfish.tyrus.grizzly.GrizzlyEndpoint;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.spi.TyrusContainer;
import org.glassfish.tyrus.spi.TyrusServer;

public class GrizzlyEngine
implements TyrusContainer {
    private final WebSocketEngine engine = WebSocketEngine.getEngine();

    @Override
    public TyrusServer createServer(String rootPath, int port) {
        final HttpServer server = HttpServer.createSimpleServer(rootPath, port);
        server.getListener("grizzly").registerAddOn(new WebSocketAddOn());
        return new TyrusServer(){

            @Override
            public void start() throws IOException {
                server.start();
            }

            @Override
            public void stop() {
                server.stop();
            }

            @Override
            public SPIRegisteredEndpoint register(SPIEndpoint endpoint) {
                GrizzlyEndpoint ge = new GrizzlyEndpoint(endpoint);
                GrizzlyEngine.this.engine.register(ge);
                return ge;
            }

            @Override
            public void unregister(SPIRegisteredEndpoint ge) {
                GrizzlyEngine.this.engine.unregister((GrizzlyEndpoint)ge);
            }
        };
    }

    @Override
    public TyrusClientSocket openClientSocket(String path, ClientEndpointConfiguration cec, SPIEndpoint endpoint) {
        URI uri;
        try {
            uri = new URI(path);
        }
        catch (URISyntaxException e) {
            return null;
        }
        GrizzlyClientSocket clientSocket = new GrizzlyClientSocket(uri, cec, 1000L);
        clientSocket.addEndpoint(endpoint);
        clientSocket.connect();
        return clientSocket;
    }
}

