/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.gf.ejb;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.tyrus.spi.ComponentProvider;

public class EjbComponentProvider
extends ComponentProvider {
    private static final Logger LOGGER = Logger.getLogger(EjbComponentProvider.class.getName());

    @Override
    public <T> T provideInstance(Class<T> c) throws Exception {
        String name = this.getName(c);
        if (name == null) {
            return null;
        }
        try {
            InitialContext ic = new InitialContext();
            return (T)this.lookup(ic, c, name);
        }
        catch (NamingException ex) {
            String message = "An instance of EJB class " + c.getName() + " could not be looked up using simple form name or the fully-qualified form name.";
            LOGGER.log(Level.SEVERE, message, ex);
            throw new Exception(message);
        }
    }

    @Override
    public boolean isApplicable(Class<?> c) {
        return c.isAnnotationPresent(Stateless.class) || c.isAnnotationPresent(Singleton.class);
    }

    private String getName(Class<?> c) {
        String name = null;
        if (c.isAnnotationPresent(Stateless.class)) {
            name = c.getAnnotation(Stateless.class).name();
        } else if (c.isAnnotationPresent(Singleton.class)) {
            name = c.getAnnotation(Singleton.class).name();
        } else {
            return null;
        }
        if (name == null || name.length() == 0) {
            name = c.getSimpleName();
        }
        return name;
    }

    private Object lookup(InitialContext ic, Class<?> c, String name) throws NamingException {
        try {
            return this.lookupSimpleForm(ic, c, name);
        }
        catch (NamingException ex) {
            LOGGER.log(Level.WARNING, "An instance of EJB class " + c.getName() + " could not be looked up using simple form name. " + "Attempting to look up using the fully-qualified form name.", ex);
            return this.lookupFullyQualfiedForm(ic, c, name);
        }
    }

    private Object lookupSimpleForm(InitialContext ic, Class<?> c, String name) throws NamingException {
        String jndiName = "java:module/" + name;
        return ic.lookup(jndiName);
    }

    private Object lookupFullyQualfiedForm(InitialContext ic, Class<?> c, String name) throws NamingException {
        String jndiName = "java:module/" + name + "!" + c.getName();
        return ic.lookup(jndiName);
    }
}

