/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfiguration;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketClient;
import javax.websocket.WebSocketClose;
import javax.websocket.WebSocketEndpoint;
import javax.websocket.WebSocketError;
import javax.websocket.WebSocketMessage;
import javax.websocket.WebSocketOpen;
import javax.websocket.WebSocketPathParam;
import org.glassfish.tyrus.AsyncMessageHandler;
import org.glassfish.tyrus.BasicMessageHandler;
import org.glassfish.tyrus.ComponentProviderService;
import org.glassfish.tyrus.DecoderWrapper;
import org.glassfish.tyrus.DefaultClientEndpointConfiguration;
import org.glassfish.tyrus.DefaultEndpointConfiguration;
import org.glassfish.tyrus.DefaultServerEndpointConfiguration;
import org.glassfish.tyrus.PrimitivesToBoxing;
import org.glassfish.tyrus.ReflectionHelper;

public class AnnotatedEndpoint
extends Endpoint {
    private static final Logger LOGGER = Logger.getLogger(AnnotatedEndpoint.class.getName());
    private final Object annotatedInstance;
    private final Method onOpenMethod;
    private final Method onCloseMethod;
    private final Method onErrorMethod;
    private final ParameterExtractor[] onOpenParameters;
    private final ParameterExtractor[] onCloseParameters;
    private final ParameterExtractor[] onErrorParameters;
    private final EndpointConfiguration configuration;
    private Set<MessageHandlerFactory> messageHandlerFactories = new HashSet<MessageHandlerFactory>();

    public static AnnotatedEndpoint fromClass(Class<?> annotatedClass) {
        return new AnnotatedEndpoint(annotatedClass, null, AnnotatedEndpoint.createEndpointConfiguration(annotatedClass));
    }

    public static AnnotatedEndpoint fromInstance(Object annotatedInstance) {
        return new AnnotatedEndpoint(annotatedInstance.getClass(), annotatedInstance, AnnotatedEndpoint.createEndpointConfiguration(annotatedInstance.getClass()));
    }

    private static EndpointConfiguration createEndpointConfiguration(Class<?> annotatedClass) {
        String[] subProtocols;
        Class<? extends Decoder>[] decoderClasses;
        Class<? extends Encoder>[] encoderClasses;
        WebSocketEndpoint wseAnnotation = annotatedClass.getAnnotation(WebSocketEndpoint.class);
        if (wseAnnotation == null) {
            WebSocketClient wscAnnotation = annotatedClass.getAnnotation(WebSocketClient.class);
            if (wscAnnotation == null) {
                return null;
            }
            encoderClasses = wscAnnotation.encoders();
            decoderClasses = wscAnnotation.decoders();
            subProtocols = wscAnnotation.subprotocols();
        } else {
            encoderClasses = wseAnnotation.encoders();
            decoderClasses = wseAnnotation.decoders();
            subProtocols = wseAnnotation.subprotocols();
        }
        ArrayList<Encoder> encoders = new ArrayList<Encoder>();
        if (encoderClasses != null) {
            for (Class<? extends Encoder> encoderClass : encoderClasses) {
                Encoder encoder = ComponentProviderService.getInstance(encoderClass);
                if (encoder == null) continue;
                encoders.add(encoder);
            }
        }
        ArrayList<Decoder> decoders = new ArrayList<Decoder>();
        if (decoderClasses != null) {
            for (Class<? extends Decoder> decoderClass : decoderClasses) {
                Class<?> decoderType = AnnotatedEndpoint.getDecoderClassType(decoderClass);
                Decoder decoder = ComponentProviderService.getInstance(decoderClass);
                if (decoder == null) continue;
                decoders.add(new DecoderWrapper(decoder, decoderType, decoderClass));
            }
        }
        DefaultClientEndpointConfiguration.Builder builder = wseAnnotation == null ? new DefaultClientEndpointConfiguration.Builder() : new DefaultServerEndpointConfiguration.Builder(wseAnnotation.value()).origins(Collections.<String>emptyList());
        return ((DefaultEndpointConfiguration.Builder)((DefaultEndpointConfiguration.Builder)((DefaultEndpointConfiguration.Builder)builder.encoders(encoders)).decoders(decoders)).protocols(subProtocols == null ? Collections.emptyList() : Arrays.asList(subProtocols))).build();
    }

    private static Class<?> getDecoderClassType(Class<?> decoder) {
        Class rootClass = null;
        if (Decoder.Text.class.isAssignableFrom(decoder)) {
            rootClass = Decoder.Text.class;
        } else if (Decoder.Binary.class.isAssignableFrom(decoder)) {
            rootClass = Decoder.Binary.class;
        } else if (Decoder.TextStream.class.isAssignableFrom(decoder)) {
            rootClass = Decoder.TextStream.class;
        } else if (Decoder.BinaryStream.class.isAssignableFrom(decoder)) {
            rootClass = Decoder.BinaryStream.class;
        }
        ReflectionHelper.DeclaringClassInterfacePair p = ReflectionHelper.getClass(decoder, rootClass);
        Class[] as = ReflectionHelper.getParameterizedClassArguments(p);
        return as == null ? Object.class : (as[0] == null ? Object.class : as[0]);
    }

    private AnnotatedEndpoint(Class<?> annotatedClass, Object instance, EndpointConfiguration config) {
        this.configuration = config;
        Object object = this.annotatedInstance = instance == null ? ComponentProviderService.getInstance(annotatedClass) : instance;
        if (this.annotatedInstance == null) {
            throw new RuntimeException("Unable to instantiate endpoint class: " + annotatedClass);
        }
        Method onOpen = null;
        Method onClose = null;
        Method onError = null;
        ParameterExtractor[] onOpenParameters = null;
        ParameterExtractor[] onCloseParameters = null;
        ParameterExtractor[] onErrorParameters = null;
        HashMap unknownParams = new HashMap();
        for (Method m : annotatedClass.getDeclaredMethods()) {
            for (Annotation a : m.getAnnotations()) {
                if (a instanceof WebSocketOpen) {
                    if (onOpen == null) {
                        onOpen = m;
                        onOpenParameters = this.getParameterExtractors(m, unknownParams);
                        if (unknownParams.isEmpty()) continue;
                        LOGGER.warning("Unknown parameter(s) for " + annotatedClass.getName() + "." + m.getName() + " method annotated with @WebSocketOpen annotation: " + unknownParams + ". This" + " method will be ignored.");
                        onOpen = null;
                        onOpenParameters = null;
                        continue;
                    }
                    LOGGER.warning("Multiple methods using @WebSocketOpen annotation in class " + annotatedClass.getName() + ": " + onOpen.getName() + " and " + m.getName() + ". The latter will be ignored.");
                    continue;
                }
                if (a instanceof WebSocketClose) {
                    if (onClose == null) {
                        onClose = m;
                        onCloseParameters = this.getParameterExtractors(m, unknownParams);
                        if (unknownParams.size() == 1 && unknownParams.values().iterator().next() != CloseReason.class) {
                            onCloseParameters[((Integer)unknownParams.keySet().iterator().next()).intValue()] = new ParamValue(0);
                            continue;
                        }
                        if (unknownParams.isEmpty()) continue;
                        LOGGER.warning("Unknown parameter(s) for " + annotatedClass.getName() + "." + m.getName() + " method annotated with @WebSocketClose annotation: " + unknownParams + ". This" + " method will be ignored.");
                        onClose = null;
                        onCloseParameters = null;
                        continue;
                    }
                    LOGGER.warning("Multiple methods using @WebSocketClose annotation in class " + annotatedClass.getName() + ": " + onClose.getName() + " and " + m.getName() + ". The latter will be ignored.");
                    continue;
                }
                if (a instanceof WebSocketError) {
                    if (onError == null) {
                        onError = m;
                        onErrorParameters = this.getParameterExtractors(m, unknownParams);
                        if (unknownParams.size() == 1 && Throwable.class == unknownParams.values().iterator().next()) {
                            onErrorParameters[((Integer)unknownParams.keySet().iterator().next()).intValue()] = new ParamValue(0);
                            continue;
                        }
                        if (unknownParams.isEmpty()) continue;
                        LOGGER.warning("Unknown parameter(s) for " + annotatedClass.getName() + "." + m.getName() + " method annotated with @WebSocketError annotation: " + unknownParams + ". This" + " method will be ignored.");
                        onError = null;
                        onErrorParameters = null;
                        continue;
                    }
                    LOGGER.warning("Multiple methods using @WebSocketError annotation in class " + annotatedClass.getName() + ": " + onError.getName() + " and " + m.getName() + ". The latter will be ignored.");
                    continue;
                }
                if (!(a instanceof WebSocketMessage)) continue;
                ParameterExtractor[] extractors = this.getParameterExtractors(m, unknownParams);
                if (unknownParams.isEmpty()) {
                    LOGGER.warning("Method " + annotatedClass.getName() + "." + m.getName() + " is annotated with " + "@WebSocketMessage annotation but does not have any parameter representing the" + " message. This method will be ignored.");
                    continue;
                }
                if (unknownParams.size() == 1) {
                    Map.Entry entry = unknownParams.entrySet().iterator().next();
                    extractors[((Integer)entry.getKey()).intValue()] = new ParamValue(0);
                    this.messageHandlerFactories.add(new BasicHandler(m, extractors, (Class)entry.getValue()));
                    continue;
                }
                if (unknownParams.size() == 2) {
                    Map.Entry last;
                    Iterator it = unknownParams.entrySet().iterator();
                    Map.Entry message = it.next();
                    if (message.getValue() == Boolean.TYPE || message.getValue() == Boolean.class) {
                        last = message;
                        message = it.next();
                    } else {
                        last = it.next();
                    }
                    extractors[((Integer)message.getKey()).intValue()] = new ParamValue(0);
                    extractors[((Integer)last.getKey()).intValue()] = new ParamValue(1);
                    if (last.getValue() == Boolean.TYPE || last.getValue() == Boolean.class) {
                        this.messageHandlerFactories.add(new AsyncHandler(m, extractors, (Class)message.getValue()));
                        continue;
                    }
                }
                LOGGER.warning("Method " + annotatedClass.getName() + "." + m.getName() + " annotated with " + "@WebSocketMessage annotation has unknown parameters: " + unknownParams + ". This " + "method will be ignored.");
            }
        }
        this.onOpenMethod = onOpen;
        this.onErrorMethod = onError;
        this.onCloseMethod = onClose;
        this.onOpenParameters = onOpenParameters;
        this.onErrorParameters = onErrorParameters;
        this.onCloseParameters = onCloseParameters;
    }

    private ParameterExtractor[] getParameterExtractors(Method method, Map<Integer, Class<?>> unknownParams) {
        ParameterExtractor[] result = new ParameterExtractor[method.getParameterTypes().length];
        unknownParams.clear();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> type2 = method.getParameterTypes()[i];
            final String pathParamName = this.getPathParamName(method.getParameterAnnotations()[i]);
            if (pathParamName != null) {
                result[i] = new ParameterExtractor(){

                    @Override
                    public Object value(Session session, Object ... values) {
                        return session.getPathParameters().get(pathParamName);
                    }
                };
                continue;
            }
            if (type2 == Session.class) {
                result[i] = new ParameterExtractor(){

                    @Override
                    public Object value(Session session, Object ... values) {
                        return session;
                    }
                };
                continue;
            }
            unknownParams.put(i, type2);
        }
        return result;
    }

    private String getPathParamName(Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof WebSocketPathParam)) continue;
            return ((WebSocketPathParam)a).value();
        }
        return null;
    }

    private Object callMethod(Method method, ParameterExtractor[] extractors, Session session, Object ... params) {
        if (method != null) {
            Object endpoint = this.annotatedInstance;
            Object[] paramValues = new Object[extractors.length];
            for (int i = 0; i < paramValues.length; ++i) {
                paramValues[i] = extractors[i].value(session, params);
            }
            try {
                return method.invoke(endpoint, paramValues);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void onClose(CloseReason closeReason) {
        this.callMethod(this.onCloseMethod, this.onCloseParameters, null, closeReason);
    }

    @Override
    public void onError(Throwable thr) {
        this.callMethod(this.onErrorMethod, this.onErrorParameters, null, thr);
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.configuration;
    }

    @Override
    public void onOpen(Session session) {
        for (MessageHandlerFactory f : this.messageHandlerFactories) {
            session.addMessageHandler(f.create(session));
        }
        this.callMethod(this.onOpenMethod, this.onOpenParameters, session, new Object[0]);
    }

    class AsyncHandler
    extends MessageHandlerFactory {
        AsyncHandler(Method method, ParameterExtractor[] extractors, Class<?> type2) {
            super(method, extractors, type2);
        }

        @Override
        public MessageHandler create(final Session session) {
            return new AsyncMessageHandler(){

                public void onMessage(Object partialMessage, boolean last) {
                    AnnotatedEndpoint.this.callMethod(AsyncHandler.this.method, AsyncHandler.this.extractors, session, new Object[]{partialMessage, last});
                }

                @Override
                public Class<?> getType() {
                    return AsyncHandler.this.type;
                }
            };
        }
    }

    class BasicHandler
    extends MessageHandlerFactory {
        BasicHandler(Method method, ParameterExtractor[] extractors, Class<?> type2) {
            super(method, extractors, type2);
        }

        @Override
        public MessageHandler create(final Session session) {
            return new BasicMessageHandler(){

                public void onMessage(Object message) {
                    Object result = AnnotatedEndpoint.this.callMethod(BasicHandler.this.method, BasicHandler.this.extractors, session, new Object[]{message});
                    if (result != null) {
                        try {
                            session.getRemote().sendObject(result);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error trying to send the response.", e);
                        }
                    }
                }

                @Override
                public Class<?> getType() {
                    return BasicHandler.this.type;
                }
            };
        }
    }

    abstract class MessageHandlerFactory {
        final Method method;
        final ParameterExtractor[] extractors;
        final Class<?> type;

        MessageHandlerFactory(Method method, ParameterExtractor[] extractors, Class<?> type2) {
            this.method = method;
            this.extractors = extractors;
            this.type = PrimitivesToBoxing.getBoxing(type2) == null ? type2 : PrimitivesToBoxing.getBoxing(type2);
        }

        abstract MessageHandler create(Session var1);
    }

    static class ParamValue
    implements ParameterExtractor {
        private final int index;

        ParamValue(int index) {
            this.index = index;
        }

        @Override
        public Object value(Session session, Object ... paramValues) {
            return paramValues[this.index];
        }
    }

    static interface ParameterExtractor {
        public Object value(Session var1, Object ... var2);
    }
}

