/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.server;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
public class ServerEnvironmentImpl
implements ServerEnvironment,
PostConstruct {
    @Inject
    StartupContext startupContext;
    public static final String kGeneratedDirName = "generated";
    public static final String kRepositoryDirName = "applications";
    public static final String kAppAltDDDirName = "altdd";
    public static final String kEJBStubDirName = "ejb";
    public static final String kGeneratedXMLDirName = "xml";
    public static final String kPolicyFileDirName = "policy";
    public static final String kConfigXMLFileName = "domain.xml";
    public static final String kConfigXMLFileNameBackup = "domain.xml.bak";
    public static final String kLoggingPropertiesFileName = "logging.properties";
    public static final String kConfigDirName = "config";
    public static final String kInitFileName = "init.conf";
    public static final String DEFAULT_ADMIN_CONSOLE_CONTEXT_ROOT = "/admin";
    public static final String DEFAULT_ADMIN_CONSOLE_APP_NAME = "__admingui";
    private File root;
    private boolean verbose;
    private boolean debug;
    private ASenvPropertyReader asenv;
    private String domainName;
    private String instanceName;
    private RuntimeType serverType = RuntimeType.DAS;
    private static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";
    private static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    private ServerEnvironment.Status status = ServerEnvironment.Status.starting;

    public ServerEnvironmentImpl() {
    }

    public ServerEnvironmentImpl(File root) {
        this.root = root.getAbsoluteFile();
        this.asenv = new ASenvPropertyReader();
    }

    @Override
    public void postConstruct() {
        String installRoot = this.startupContext.getArguments().getProperty(INSTALL_ROOT_PROP_NAME);
        if (installRoot == null) {
            installRoot = System.getProperty(INSTALL_ROOT_PROP_NAME) != null ? System.getProperty(INSTALL_ROOT_PROP_NAME) : System.getProperty("user.dir");
        }
        this.asenv = new ASenvPropertyReader(new File(installRoot));
        if (this.root == null) {
            String envVar = System.getProperty(INSTANCE_ROOT_PROP_NAME);
            if (envVar != null) {
                this.root = new File(envVar);
            } else {
                String instanceRoot = this.startupContext.getArguments().getProperty(INSTANCE_ROOT_PROP_NAME);
                if (instanceRoot == null) {
                    instanceRoot = installRoot;
                }
                this.root = new File(instanceRoot);
            }
        }
        this.asenv.getProps().put(INSTANCE_ROOT_PROP_NAME, this.root.getAbsolutePath());
        for (Map.Entry<String, String> entry : this.asenv.getProps().entrySet()) {
            if (entry.getValue() == null) continue;
            File location = new File(entry.getValue());
            if (!location.isAbsolute()) {
                location = new File(this.asenv.getProps().get(INSTANCE_ROOT_PROP_NAME), entry.getValue());
            }
            System.setProperty(entry.getKey(), location.getAbsolutePath());
        }
        Properties args = this.startupContext.getArguments();
        this.verbose = Boolean.parseBoolean(args.getProperty("-verbose"));
        this.debug = Boolean.parseBoolean(args.getProperty("-debug"));
        String s = args.getProperty("-domainname");
        if (!this.ok(s)) {
            s = this.root.getName();
        }
        this.domainName = s;
        s = args.getProperty("-instancename");
        this.instanceName = !this.ok(s) ? "server" : s;
        this.asenv.getProps().put("com.sun.aas.instanceName", this.instanceName);
        System.setProperty("com.sun.aas.instanceName", this.instanceName);
        String typeString = args.getProperty("-type");
        this.serverType = RuntimeType.getDefault();
        try {
            if (typeString != null) {
                this.serverType = RuntimeType.valueOf(typeString);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public File getInstanceRoot() {
        return this.root;
    }

    @Override
    @Deprecated
    public File getDomainRoot() {
        return this.getInstanceRoot();
    }

    @Override
    public StartupContext getStartupContext() {
        return this.startupContext;
    }

    @Override
    public File getConfigDirPath() {
        return new File(this.root, kConfigDirName);
    }

    @Override
    public File getApplicationRepositoryPath() {
        return new File(this.root, kRepositoryDirName);
    }

    @Override
    public File getApplicationStubPath() {
        return new File(this.root, kGeneratedDirName);
    }

    public File getInitFilePath() {
        return new File(this.getConfigDirPath(), kInitFileName);
    }

    @Override
    public File getLibPath() {
        return new File(this.root, "lib");
    }

    @Override
    public File getApplicationEJBStubPath() {
        return new File(this.getApplicationStubPath(), kEJBStubDirName);
    }

    @Override
    public File getApplicationGeneratedXMLPath() {
        return new File(this.getApplicationStubPath(), kGeneratedXMLDirName);
    }

    @Override
    public File getApplicationCompileJspPath() {
        return new File(this.getApplicationStubPath(), "jsp");
    }

    @Override
    public File getApplicationPolicyFilePath() {
        return new File(this.getApplicationStubPath(), kPolicyFileDirName);
    }

    @Override
    public File getApplicationAltDDPath() {
        return new File(this.getApplicationStubPath(), kAppAltDDDirName);
    }

    public final String getProp(String key) {
        return this.getProps().get(key);
    }

    public Map<String, String> getProps() {
        return Collections.unmodifiableMap(this.asenv.getProps());
    }

    public File getDefaultAdminConsoleFolderOnDisk() {
        File install = new File(this.asenv.getProps().get(INSTALL_ROOT_PROP_NAME));
        File agp = new File(new File(new File(install, "lib"), "install"), kRepositoryDirName);
        return agp;
    }

    @Override
    public File getMasterPasswordFile() {
        return new File(this.getInstanceRoot(), "master-password");
    }

    @Override
    public File getJKS() {
        return new File(this.getConfigDirPath(), "keystore.jks");
    }

    @Override
    public File getTrustStore() {
        return new File(this.getConfigDirPath(), "cacerts.jks");
    }

    @Override
    public ServerEnvironment.Status getStatus() {
        return this.status;
    }

    public void setStatus(ServerEnvironment.Status status) {
        this.status = status;
    }

    public boolean isEmbedded() {
        return this.serverType == RuntimeType.EMBEDDED;
    }

    @Override
    public RuntimeType getRuntimeType() {
        return this.serverType;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public boolean isInstance() {
        return this.serverType == RuntimeType.INSTANCE;
    }

    @Override
    public boolean isDas() {
        return this.serverType == RuntimeType.DAS;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

