/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl.authorization;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.security.auth.Subject;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.security.services.api.authorization.AuthorizationService;
import org.glassfish.security.services.api.authorization.AzAction;
import org.glassfish.security.services.api.authorization.AzAttributeResolver;
import org.glassfish.security.services.api.authorization.AzResource;
import org.glassfish.security.services.api.authorization.AzResult;
import org.glassfish.security.services.api.authorization.AzSubject;
import org.glassfish.security.services.api.common.Attributes;
import org.glassfish.security.services.api.context.SecurityContextService;
import org.glassfish.security.services.config.AuthorizationService;
import org.glassfish.security.services.config.SecurityConfiguration;
import org.glassfish.security.services.config.SecurityProvider;
import org.glassfish.security.services.impl.ServiceFactory;
import org.glassfish.security.services.impl.authorization.AzActionImpl;
import org.glassfish.security.services.impl.authorization.AzEnvironmentImpl;
import org.glassfish.security.services.impl.authorization.AzResourceImpl;
import org.glassfish.security.services.impl.authorization.AzSubjectImpl;
import org.glassfish.security.services.spi.AuthorizationProvider;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public final class AuthorizationServiceImpl
implements org.glassfish.security.services.api.authorization.AuthorizationService,
PostConstruct {
    private static final Logger logger = LogDomains.getLogger(AuthorizationServiceImpl.class, "javax.enterprise.system.core.security");
    @Inject
    private volatile Domain domain;
    @Inject
    private volatile ServiceLocator serviceLocator;
    private volatile AuthorizationService atzSvCfg;
    @Inject
    private volatile SecurityContextService securityContextService;
    private volatile SecurityProvider atzPrvConfig;
    private volatile AuthorizationProvider atzProvider;
    private static final CodeSource NULL_CODESOURCE = new CodeSource(null, (CodeSigner[])null);
    private volatile InitializationState initialized = InitializationState.NOT_INITIALIZED;
    private volatile String reasonInitFailed = "Authorization Service never initialized.";
    private final List<AzAttributeResolver> attributeResolvers = Collections.synchronizedList(new ArrayList());

    @Override
    public void initialize(SecurityConfiguration securityServiceConfiguration) {
        if (InitializationState.NOT_INITIALIZED != this.initialized) {
            return;
        }
        try {
            if (!(securityServiceConfiguration instanceof AuthorizationService)) {
                throw new IllegalStateException("The Authorization service is not configured in the domain configuration file.");
            }
            this.atzSvCfg = (AuthorizationService)securityServiceConfiguration;
            List<SecurityProvider> providersConfig = this.atzSvCfg.getSecurityProviders();
            if (providersConfig == null || (this.atzPrvConfig = providersConfig.get(0)) == null) {
                throw new IllegalStateException("No provider configured for the Authorization service in the domain configuration file.");
            }
            String providerName = this.atzPrvConfig.getName();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Attempting to get Authorization provider \"{0}\".", providerName);
            }
            this.atzProvider = this.serviceLocator.getService(AuthorizationProvider.class, providerName, new Annotation[0]);
            if (this.atzProvider == null) {
                throw new IllegalStateException("Authorization provider \"" + providerName + "\" not found.");
            }
            this.atzProvider.initialize(this.atzPrvConfig);
            this.initialized = InitializationState.SUCCESS_INIT;
            this.reasonInitFailed = null;
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Authorization Service has successfully initialized.");
            }
        }
        catch (Exception e) {
            this.reasonInitFailed = MessageFormat.format("Authorization Service initialization failed, exception=\"{0}\", message=\"{1}\".", e.getClass().getName(), e.getMessage());
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, this.reasonInitFailed, e);
            }
            throw new RuntimeException(this.reasonInitFailed, e);
        }
        finally {
            if (InitializationState.SUCCESS_INIT != this.initialized) {
                this.initialized = InitializationState.FAILED_INIT;
            }
        }
    }

    @Override
    public boolean isPermissionGranted(Subject subject, Permission permission) {
        if (null == subject) {
            throw new IllegalArgumentException("Illegal null Subject.");
        }
        if (null == permission) {
            throw new IllegalArgumentException("Illegal null Permission.");
        }
        Set<Principal> principalset = subject.getPrincipals();
        Principal[] principalAr = principalset.size() == 0 ? null : principalset.toArray(new Principal[principalset.size()]);
        ProtectionDomain pd = new ProtectionDomain(NULL_CODESOURCE, null, null, principalAr);
        Policy policy = Policy.getPolicy();
        boolean result = policy.implies(pd, permission);
        return result;
    }

    @Override
    public boolean isAuthorized(Subject subject, URI resource) {
        return this.isAuthorized(subject, resource, null);
    }

    @Override
    public boolean isAuthorized(Subject subject, URI resource, String action) {
        AzAction azAction;
        AzResource azResource;
        this.checkServiceAvailability();
        if (null == subject) {
            throw new IllegalArgumentException("Illegal null Subject.");
        }
        if (null == resource) {
            throw new IllegalArgumentException("Illegal null resource URI.");
        }
        AzSubject azSubject = this.makeAzSubject(subject);
        AzResult azResult = this.getAuthorizationDecision(azSubject, azResource = this.makeAzResource(resource), azAction = this.makeAzAction(action));
        boolean result = AzResult.Status.OK.equals((Object)azResult.getStatus()) && AzResult.Decision.PERMIT.equals((Object)azResult.getDecision());
        return result;
    }

    @Override
    public AzResult getAuthorizationDecision(AzSubject subject, AzResource resource, AzAction action) {
        this.checkServiceAvailability();
        if (null == subject || null == resource) {
            throw new IllegalArgumentException("Illegal null AzSubject or AzResource.");
        }
        AzEnvironmentImpl env = new AzEnvironmentImpl();
        Attributes attrs = this.securityContextService.getEnvironmentAttributes();
        for (String attrName : attrs.getAttributeNames()) {
            env.addAttribute(attrName, attrs.getAttributeValue(attrName), true);
        }
        AzResult result = this.atzProvider.getAuthorizationDecision(subject, resource, action, env, this.attributeResolvers);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Authorization Service result for {0} was {1}.", new String[]{subject.toString(), result.toString()});
        }
        return result;
    }

    @Override
    public AzSubject makeAzSubject(Subject subject) {
        AzSubjectImpl azs = new AzSubjectImpl(subject);
        return azs;
    }

    @Override
    public AzResource makeAzResource(URI resource) {
        AzResourceImpl azr = new AzResourceImpl(resource);
        return azr;
    }

    @Override
    public AzAction makeAzAction(String action) {
        AzActionImpl aza = new AzActionImpl(action);
        return aza;
    }

    @Override
    public AuthorizationService.PolicyDeploymentContext findOrCreateDeploymentContext(String appContext) {
        this.checkServiceAvailability();
        return this.atzProvider.findOrCreateDeploymentContext(appContext);
    }

    @Override
    public void postConstruct() {
        AuthorizationService atzConfiguration = ServiceFactory.getSecurityServiceConfiguration(this.domain, AuthorizationService.class);
        this.initialize(atzConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean appendAttributeResolver(AzAttributeResolver resolver) {
        if (null == resolver) {
            throw new IllegalArgumentException("Illegal null AzAttributeResolver.");
        }
        List<AzAttributeResolver> list = this.attributeResolvers;
        synchronized (list) {
            if (!this.attributeResolvers.contains(resolver)) {
                this.attributeResolvers.add(resolver);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributeResolvers(List<AzAttributeResolver> resolverList) {
        if (null == resolverList) {
            throw new IllegalArgumentException("Illegal null List<AzAttributeResolver>.");
        }
        List<AzAttributeResolver> list = this.attributeResolvers;
        synchronized (list) {
            this.attributeResolvers.clear();
            for (AzAttributeResolver ar : resolverList) {
                if (null == ar || this.attributeResolvers.contains(ar)) continue;
                this.attributeResolvers.add(ar);
            }
        }
    }

    @Override
    public List<AzAttributeResolver> getAttributeResolvers() {
        return new ArrayList<AzAttributeResolver>(this.attributeResolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllAttributeResolvers() {
        List<AzAttributeResolver> list = this.attributeResolvers;
        synchronized (list) {
            if (this.attributeResolvers.isEmpty()) {
                return false;
            }
            this.attributeResolvers.clear();
            return true;
        }
    }

    final InitializationState getInitializationState() {
        return this.initialized;
    }

    final String getReasonInitializationFailed() {
        return this.reasonInitFailed;
    }

    final void checkServiceAvailability() {
        if (InitializationState.SUCCESS_INIT != this.getInitializationState()) {
            throw new IllegalStateException("The Authorization service is unavailable. " + this.getReasonInitializationFailed());
        }
    }

    static enum InitializationState {
        NOT_INITIALIZED,
        SUCCESS_INIT,
        FAILED_INIT;

    }
}

