/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.services.commands.CLIUtil;
import org.glassfish.security.services.config.SecurityConfiguration;
import org.glassfish.security.services.config.SecurityProvider;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-security-provider")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
public class CreateSecurityProvider
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Param(optional=false)
    private String serviceName;
    @Param(optional=false)
    private String providerName;
    @Param(optional=false)
    private String providerType;
    @Param(primary=true)
    private String name;
    @Inject
    private Domain domain;
    @AccessRequired.NewChild(type=SecurityProvider.class)
    private SecurityConfiguration securityServiceConfiguration;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.securityServiceConfiguration = CLIUtil.findSecurityConfiguration(this.domain, this.serviceName, context.getActionReport());
        return this.securityServiceConfiguration != null;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply(new SingleConfigCode<SecurityConfiguration>(){

                @Override
                public Object run(SecurityConfiguration param) throws PropertyVetoException, TransactionFailure {
                    SecurityProvider providerConfig = param.createChild(SecurityProvider.class);
                    providerConfig.setName(CreateSecurityProvider.this.name);
                    providerConfig.setType(CreateSecurityProvider.this.providerType);
                    providerConfig.setProviderName(CreateSecurityProvider.this.providerName);
                    param.getSecurityProviders().add(providerConfig);
                    return providerConfig;
                }
            }, this.securityServiceConfiguration);
        }
        catch (TransactionFailure transactionFailure) {
            report.setMessage("Unable to create security provider: " + transactionFailure.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(transactionFailure);
        }
    }
}

