/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resources.config.CustomResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-custom-resource")
@PerLookup
@I18n(value="delete.custom.resource")
public class DeleteCustomResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteCustomResource.class);
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private ResourceUtil resourceUtil;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.domain.getResources().getResourceByName(CustomResource.class, this.jndiName) == null) {
            report.setMessage(localStrings.getLocalString("delete.custom.resource.notfound", "A custom resource named {0} does not exist.", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.environment.isDas()) {
            if ("domain".equals(this.target)) {
                if (this.resourceUtil.getTargetsReferringResourceRef(this.jndiName).size() > 0) {
                    report.setMessage(localStrings.getLocalString("delete.custom.resource.resource-ref.exist", "custom-resource [ {0} ] is referenced in aninstance/cluster target, Use delete-resource-ref on appropriate target", this.jndiName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(this.jndiName, this.target)) {
                    report.setMessage(localStrings.getLocalString("delete.custom.resource.no.resource-ref", "custom-resource [ {0} ] is not referenced in target [ {1} ]", this.jndiName, this.target));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(this.jndiName).size() > 1) {
                    report.setMessage(localStrings.getLocalString("delete.custom.resource.multiple.resource-refs", "custom-resource [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", this.jndiName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        try {
            this.resourceUtil.deleteResourceRef(this.jndiName, this.target);
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    CustomResource resource = (CustomResource)DeleteCustomResource.this.domain.getResources().getResourceByName(CustomResource.class, DeleteCustomResource.this.jndiName);
                    if (resource != null && resource.getJndiName().equals(DeleteCustomResource.this.jndiName)) {
                        return param.getResources().remove(resource);
                    }
                    return null;
                }
            }, this.domain.getResources());
            report.setMessage(localStrings.getLocalString("delete.custom.resource.success", "Custom resource {0} deleted", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.custom.resource.fail", "Unable to delete custom resource {0}", this.jndiName) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
        }
    }
}

