/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.pfl.dynamic.codegen.spi.ClassInfo;
import org.glassfish.pfl.dynamic.codegen.spi.FieldInfo;
import org.glassfish.pfl.dynamic.codegen.spi.MethodInfo;
import org.glassfish.pfl.dynamic.codegen.spi.Signature;
import org.glassfish.pfl.dynamic.codegen.spi.Type;

public abstract class ClassInfoBase
implements ClassInfo {
    private int modifiers;
    private Type thisType;
    private String className;
    private String pkgName;
    private boolean initComplete;
    private boolean isInterface;
    private Type superType;
    private List<Type> impls;
    private Map<String, Set<MethodInfo>> methodInfoByName;
    private Set<MethodInfo> constructors;
    private Map<String, FieldInfo> fields;
    private boolean hashIsCached;
    private int hashValue;

    public ClassInfoBase(int modifiers, Type thisType) {
        this.modifiers = modifiers;
        this.thisType = thisType;
        String name = thisType.name();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            this.className = name;
            this.pkgName = "";
        } else {
            this.className = name.substring(index + 1);
            this.pkgName = name.substring(0, index);
        }
        this.initComplete = false;
        this.constructors = new HashSet<MethodInfo>();
        this.methodInfoByName = new LinkedHashMap<String, Set<MethodInfo>>();
        this.fields = new LinkedHashMap<String, FieldInfo>();
        this.hashValue = 0;
        this.hashIsCached = false;
    }

    private void checkComplete() {
        if (!this.initComplete) {
            throw new IllegalStateException("ClassInfoBase initialization is not complete");
        }
    }

    private void checkReinitialize() {
        if (this.initComplete) {
            throw new IllegalStateException("ClassInfoBase cannot be reinitialized");
        }
    }

    protected void initializeInterface(List<Type> exts) {
        this.checkReinitialize();
        this.isInterface = true;
        this.superType = null;
        this.impls = exts;
        this.initComplete = true;
    }

    protected void initializeClass(Type thisType, Type superType, List<Type> impls) {
        this.checkReinitialize();
        this.isInterface = false;
        this.thisType = thisType;
        this.superType = superType;
        this.impls = impls;
        this.initComplete = true;
    }

    protected void addFieldInfo(FieldInfo finfo) {
        int mod;
        this.checkComplete();
        this.clearHashCode();
        if (!(!this.isInterface || Modifier.isPublic(mod = finfo.modifiers()) && Modifier.isFinal(mod) && Modifier.isStatic(mod))) {
            throw new IllegalStateException("Only public static final fields can be added to an interface");
        }
        this.fields.put(finfo.name(), finfo);
    }

    protected void addMethodInfo(MethodInfo minfo) {
        this.checkComplete();
        this.clearHashCode();
        Set<MethodInfo> minfos = this.methodInfoByName.get(minfo.name());
        if (minfos == null) {
            minfos = new HashSet<MethodInfo>();
            this.methodInfoByName.put(minfo.name(), minfos);
        }
        if (this.isInterface && !Modifier.isAbstract(minfo.modifiers())) {
            throw new IllegalStateException("All methods in an interface must be abstract");
        }
        minfos.add(minfo);
    }

    protected void addConstructorInfo(MethodInfo cinfo) {
        this.checkComplete();
        this.clearHashCode();
        if (this.isInterface) {
            throw new IllegalStateException("Cannot add a constructor to an interface");
        }
        this.constructors.add(cinfo);
    }

    @Override
    public Type thisType() {
        return this.thisType;
    }

    @Override
    public boolean isInterface() {
        this.checkComplete();
        return this.isInterface;
    }

    @Override
    public int modifiers() {
        return this.modifiers;
    }

    @Override
    public String name() {
        return this.thisType.name();
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public String pkgName() {
        return this.pkgName;
    }

    @Override
    public Type superType() {
        this.checkComplete();
        return this.superType;
    }

    @Override
    public List<Type> impls() {
        this.checkComplete();
        return this.impls;
    }

    @Override
    public Map<String, FieldInfo> fieldInfo() {
        this.checkComplete();
        return this.fields;
    }

    @Override
    public FieldInfo findFieldInfo(String name) {
        FieldInfo info = this.fields.get(name);
        if (info == null) {
            if (this.superType() == null) {
                return null;
            }
            ClassInfo superInfo = this.superType().classInfo();
            info = superInfo.findFieldInfo(name);
        }
        return info;
    }

    @Override
    public Map<String, Set<MethodInfo>> methodInfoByName() {
        this.checkComplete();
        return this.methodInfoByName;
    }

    @Override
    public Set<MethodInfo> constructorInfo() {
        return this.constructors;
    }

    private MethodInfo findMethodInfo(Signature sig, Set<MethodInfo> minfos) {
        if (minfos != null) {
            for (MethodInfo minfo : minfos) {
                if (!sig.equals(minfo.signature())) continue;
                return minfo;
            }
        }
        return null;
    }

    @Override
    public MethodInfo findMethodInfo(String name, Signature sig) {
        MethodInfo result = null;
        ClassInfo current = this;
        while (current != null) {
            Set<MethodInfo> minfos = current.methodInfoByName().get(name);
            result = this.findMethodInfo(sig, minfos);
            if (result != null) {
                return result;
            }
            if (current.superType() == null) {
                current = null;
                continue;
            }
            current = current.superType().classInfo();
        }
        for (Type type2 : this.impls) {
            result = type2.classInfo().findMethodInfo(name, sig);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    @Override
    public MethodInfo findConstructorInfo(Signature sig) {
        return this.findMethodInfo(sig, this.constructors);
    }

    @Override
    public boolean isSubclass(ClassInfo info) {
        if (this.equals(info)) {
            return true;
        }
        if (info.equals(Type._Object().classInfo())) {
            return true;
        }
        if (this.superType() != null && this.superType().classInfo().isSubclass(info)) {
            return true;
        }
        for (Type t : this.impls()) {
            if (!t.classInfo().isSubclass(info)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        this.checkComplete();
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClassInfo)) {
            return false;
        }
        ClassInfo other = (ClassInfo)ClassInfo.class.cast(obj);
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!this.thisType().equals(other.thisType())) {
            return false;
        }
        if (this.isInterface() != other.isInterface()) {
            return false;
        }
        if (this.modifiers() != other.modifiers()) {
            return false;
        }
        if (!this.name().equals(other.name())) {
            return false;
        }
        if (this.superType() == null ? other.superType() != null : !this.superType().equals(other.superType())) {
            return false;
        }
        if (!((Object)this.impls()).equals(other.impls())) {
            return false;
        }
        if (!((Object)this.fieldInfo().entrySet()).equals(other.fieldInfo().entrySet())) {
            return false;
        }
        if (!((Object)this.methodInfoByName()).equals(other.methodInfoByName())) {
            return false;
        }
        return ((Object)this.constructorInfo()).equals(other.constructorInfo());
    }

    public String toString() {
        this.checkComplete();
        String className = this.getClass().getName();
        int lindex = className.lastIndexOf(46);
        if (lindex >= 0) {
            className = className.substring(lindex + 1);
        }
        return className + "[" + this.name() + "]";
    }

    private synchronized void clearHashCode() {
        this.hashIsCached = false;
        this.hashValue = 0;
    }

    public synchronized int hashCode() {
        this.checkComplete();
        if (!this.hashIsCached) {
            this.hashValue ^= this.thisType().hashCode();
            this.hashValue ^= this.isInterface() ? 0 : 1;
            this.hashValue ^= this.modifiers();
            if (this.superType() != null) {
                this.hashValue ^= this.superType().hashCode();
            }
            this.hashValue ^= ((Object)this.impls()).hashCode();
            this.hashValue ^= ((Object)this.fieldInfo()).hashCode();
            this.hashValue ^= ((Object)this.methodInfoByName()).hashCode();
            if (this.constructorInfo() != null) {
                this.hashValue ^= ((Object)this.constructorInfo()).hashCode();
            }
            this.hashIsCached = true;
        }
        return this.hashValue;
    }
}

