/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.tools.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.tools.file.FileWrapper;

public class Block {
    private List<String> data;
    private final Set<String> tags;

    private Block(List<String> data, Set<String> tags) {
        this.data = data;
        this.tags = tags;
    }

    public Block(List<String> data) {
        this.data = data;
        this.tags = new HashSet<String>();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Block[");
        boolean first = true;
        for (String tag : this.tags) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(tag);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block block = (Block)obj;
        Iterator<String> iter1 = this.data.iterator();
        Iterator<String> iter2 = block.data.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            String str2;
            String str1 = iter1.next();
            if (str1.equals(str2 = iter2.next())) continue;
            return false;
        }
        return iter1.hasNext() == iter2.hasNext();
    }

    public int hashCode() {
        int hash = 0;
        for (String str : this.data) {
            hash ^= ((Object)this.data).hashCode();
        }
        return hash;
    }

    public Block(Block block) {
        this.data = new ArrayList<String>(block.data);
        this.tags = new HashSet<String>(block.tags);
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public boolean hasTags(String ... tags) {
        for (String tag : tags) {
            if (this.hasTag(tag)) continue;
            return false;
        }
        return true;
    }

    public List<String> contents() {
        return this.data;
    }

    public void addBeforeFirst(String str) {
        this.data.add(0, str);
    }

    public void addAfterLast(String str) {
        this.data.add(this.data.size(), str);
    }

    public void addPrefixToAll(String prefix) {
        ArrayList<String> newData = new ArrayList<String>();
        for (String str : this.data) {
            newData.add(prefix + str);
        }
        this.data = newData;
    }

    public String find(String search) {
        for (String str : this.data) {
            if (!str.contains(search)) continue;
            return str;
        }
        return null;
    }

    public void write(FileWrapper fw) throws IOException {
        for (String str : this.data) {
            fw.writeLine(str);
        }
    }

    public Block instantiateTemplate(Map<String, String> parameters) {
        ArrayList<String> result = new ArrayList<String>(this.data.size());
        for (String str : this.data) {
            StringBuilder sb = new StringBuilder();
            StringTokenizer st = new StringTokenizer(str, "@");
            boolean isKeyword = false;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String replacement = isKeyword ? parameters.get(token) : token;
                sb.append(replacement);
                isKeyword = !isKeyword;
            }
            result.add(sb.toString());
        }
        return new Block(result);
    }

    private String expandTabs(String src) {
        int outCtr = 0;
        StringBuilder result = new StringBuilder();
        for (int ctr = 0; ctr < src.length(); ++ctr) {
            char ch = src.charAt(ctr);
            if (ch == '\t') {
                int nextTab = (outCtr >> 3) + 1 << 3;
                while (outCtr < nextTab) {
                    result.append(' ');
                    ++outCtr;
                }
                continue;
            }
            result.append(ch);
            ++outCtr;
        }
        return result.toString();
    }

    public Block expandTabs() {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : this.data) {
            String exp = this.expandTabs(line);
            result.add(exp);
        }
        return new Block(result);
    }

    public Block substitute(List<? extends Pair<String, String>> substitutions) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> i$ = this.data.iterator();
        while (i$.hasNext()) {
            String line;
            String newLine = line = i$.next();
            for (Pair<String, String> pair : substitutions) {
                String pattern = pair.first();
                String replacement = pair.second();
                newLine = newLine.replace(pattern, replacement);
            }
            result.add(newLine);
        }
        return new Block(result);
    }

    public Pair<Block, Block> splitFirst() {
        ArrayList<String> first = new ArrayList<String>();
        ArrayList<String> rest = new ArrayList<String>();
        for (String str : this.data) {
            if (first.isEmpty()) {
                first.add(str);
                continue;
            }
            rest.add(str);
        }
        Block block1 = new Block(first, new HashSet<String>(this.tags));
        Block block2 = new Block(rest, new HashSet<String>(this.tags));
        Pair<Block, Block> result = new Pair<Block, Block>(block1, block2);
        return result;
    }
}

