/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.reader.impl;

import com.sun.enterprise.config.serverbeans.HealthChecker;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.reader.api.HealthCheckerReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.LbReaderException;
import org.glassfish.loadbalancer.admin.cli.transform.HealthCheckerVisitor;
import org.glassfish.loadbalancer.admin.cli.transform.Visitor;

public class HealthCheckerReaderImpl
implements HealthCheckerReader {
    HealthChecker _hc = null;
    private static final HealthCheckerReader defaultHCR = new HealthCheckerReaderImpl();
    private static final String defaultURL = "/";
    private static final String defaultInterval = "10";
    private static final String defaultTimeout = "30";

    static HealthCheckerReader getDefaultHealthChecker() {
        return defaultHCR;
    }

    public HealthCheckerReaderImpl() {
        this._hc = null;
    }

    public HealthCheckerReaderImpl(HealthChecker hc) {
        if (hc == null) {
            String msg = LbLogUtil.getStringManager().getString("ConfigBeanAndNameNull");
            throw new IllegalArgumentException(msg);
        }
        this._hc = hc;
    }

    @Override
    public String getUrl() throws LbReaderException {
        if (this._hc == null) {
            return defaultURL;
        }
        return this._hc.getUrl();
    }

    @Override
    public String getIntervalInSeconds() throws LbReaderException {
        if (this._hc == null) {
            return defaultInterval;
        }
        return this._hc.getIntervalInSeconds();
    }

    @Override
    public String getTimeoutInSeconds() throws LbReaderException {
        if (this._hc == null) {
            return defaultTimeout;
        }
        return this._hc.getTimeoutInSeconds();
    }

    @Override
    public void accept(Visitor v) throws Exception {
        HealthCheckerVisitor pv = (HealthCheckerVisitor)v;
        pv.visit(this);
    }
}

