/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.config.LbConfig;
import org.glassfish.loadbalancer.config.LbConfigs;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-http-lb-configs")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=LbConfigs.class, opType=RestEndpoint.OpType.GET, path="list-http-lb-configs", description="list-http-lb-configs")})
public final class ListLBConfigsCommand
implements AdminCommand {
    @Param(primary=true, optional=true)
    String list_target;
    @Inject
    Domain domain;
    @Inject
    Target tgt;
    @Inject
    Logger logger;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListLBConfigsCommand.class);

    @Override
    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        ActionReport.MessagePart part = this.report.getTopMessagePart();
        boolean isCluster = this.tgt.isCluster(this.list_target);
        LbConfigs lbconfigs = this.domain.getExtensionByType(LbConfigs.class);
        if (lbconfigs == null) {
            this.logger.fine(localStrings.getLocalString("http_lb_admin.NoLbConfigs", "No lb configs"));
            return;
        }
        List<LbConfig> lbconfigsList = lbconfigs.getLbConfig();
        if (lbconfigsList.size() == 0) {
            this.logger.fine(localStrings.getLocalString("http_lb_admin.NoLbConfigs", "No lb configs"));
            return;
        }
        if (this.list_target == null) {
            for (LbConfig lbc : lbconfigsList) {
                ActionReport.MessagePart childPart = part.addChild();
                childPart.setMessage(lbc.getName());
            }
        } else if (isCluster) {
            for (LbConfig lbc : lbconfigsList) {
                List<ClusterRef> refs = lbc.getRefs(ClusterRef.class);
                for (ClusterRef cRef : refs) {
                    if (!cRef.getRef().equals(this.list_target)) continue;
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(lbc.getName());
                }
            }
        } else if (this.domain.isServer(this.list_target)) {
            for (LbConfig lbc : lbconfigsList) {
                List<ServerRef> refs = lbc.getRefs(ServerRef.class);
                for (ServerRef sRef : refs) {
                    if (!sRef.getRef().equals(this.list_target)) continue;
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(lbc.getName());
                }
            }
        } else {
            LbConfig lbConfig = lbconfigs.getLbConfig(this.list_target);
            if (lbConfig != null) {
                List<ClusterRef> cRefs = lbConfig.getRefs(ClusterRef.class);
                for (ClusterRef ref : cRefs) {
                    String s = localStrings.getLocalString("ClusterPrefix", "Cluster:");
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(s + ref.getRef());
                }
                List<ServerRef> sRefs = lbConfig.getRefs(ServerRef.class);
                for (ServerRef ref : sRefs) {
                    String s = localStrings.getLocalString("ServerPrefix", "Server:");
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(s + ref.getRef());
                }
            }
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

