/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jspcaching.integration;

import com.sun.appserv.web.taglibs.cache.CacheTag;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.net.JarURIPattern;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.web.TldProvider;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.web.config.serverbeans.WebContainer;
import org.glassfish.web.loader.WebappClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service(name="jspCachingTld")
@Singleton
public class GlassFishTldProvider
implements TldProvider,
PostConstruct {
    private static final Logger logger = WebappClassLoader.logger;
    private static final ResourceBundle rb = logger.getResourceBundle();
    @Inject
    ServerContext serverContext;
    @Inject
    ModulesRegistry registry;
    private Map<URI, List<String>> tldMap = new HashMap<URI, List<String>>();

    @Override
    public String getName() {
        return "jspCachingTld";
    }

    @Override
    public Map<URI, List<String>> getTldMap() {
        return this.tldMap == null ? null : (Map)((HashMap)this.tldMap).clone();
    }

    @Override
    public Map<URI, List<String>> getTldListenerMap() {
        return this.getTldMap();
    }

    @Override
    public void postConstruct() {
        Config cfg = this.serverContext.getDefaultServices().getService(Config.class, "default-instance-name", new Annotation[0]);
        WebContainer webContainer = cfg.getExtensionByType(WebContainer.class);
        if (webContainer == null) {
            return;
        }
        if (!Boolean.valueOf(webContainer.getJspCachingEnabled()).booleanValue()) {
            return;
        }
        Class<CacheTag> jspCachingImplClass = CacheTag.class;
        URI[] uris = null;
        Module m = null;
        if (jspCachingImplClass != null) {
            m = this.registry.find(jspCachingImplClass);
        }
        if (m != null) {
            uris = m.getModuleDefinition().getLocations();
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                if (urls != null && urls.length > 0) {
                    uris = new URI[urls.length];
                    for (int i = 0; i < urls.length; ++i) {
                        try {
                            uris[i] = urls[i].toURI();
                            continue;
                        }
                        catch (URISyntaxException e) {
                            String msg = rb.getString("AS-WEB-UTIL-000037");
                            msg = MessageFormat.format(msg, urls[i]);
                            logger.log(Level.WARNING, msg, e);
                        }
                    }
                }
            } else {
                logger.log(Level.WARNING, "AS-WEB-UTIL-000038", new Object[]{"JSP Caching", classLoader, GlassFishTldProvider.class.getName()});
            }
        }
        if (uris != null && uris.length > 0) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (URI uri : uris) {
                List<String> entries = JarURIPattern.getJarEntries(uri, pattern);
                if (entries == null || entries.size() <= 0) continue;
                this.tldMap.put(uri, entries);
            }
        }
    }
}

