/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.async;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;

public class AsyncContextDelegateProviderImpl
implements AsyncContextDelegateProvider {
    @Override
    public final AsyncContextDelegate createDelegate(HttpServletRequest request, HttpServletResponse response) {
        return new ExtensionImpl(request, response);
    }

    private static final class ExtensionImpl
    implements AsyncContextDelegate {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final AtomicReference<AsyncContext> asyncContextRef;

        private ExtensionImpl(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
            this.asyncContextRef = new AtomicReference();
        }

        @Override
        public void suspend(final ContainerResponseWriter writer, long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) throws IllegalStateException {
            AsyncContext asyncContext = this.request.startAsync(this.request, this.response);
            asyncContext.setTimeout(timeUnit.toMillis(timeOut));
            asyncContext.addListener(new AsyncListener(){

                @Override
                public void onComplete(AsyncEvent event) throws IOException {
                }

                @Override
                public void onTimeout(AsyncEvent event) throws IOException {
                    if (timeoutHandler != null) {
                        timeoutHandler.onTimeout(writer);
                    }
                }

                @Override
                public void onError(AsyncEvent event) throws IOException {
                }

                @Override
                public void onStartAsync(AsyncEvent event) throws IOException {
                }
            });
            this.asyncContextRef.set(asyncContext);
        }

        @Override
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            AsyncContext asyncContext = this.asyncContextRef.get();
            if (asyncContext == null) {
                throw new IllegalStateException("Not suspended.");
            }
            asyncContext.setTimeout(timeUnit.toMillis(timeOut));
        }

        @Override
        public void complete() {
            AsyncContext asyncContext = this.asyncContextRef.getAndSet(null);
            if (asyncContext != null) {
                asyncContext.complete();
            }
        }
    }
}

