/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.jersey.internal.ServiceFinderBinder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.glassfish.jersey.servlet.ServletPropertiesDelegate;
import org.glassfish.jersey.servlet.WebAppResourcesScanner;
import org.glassfish.jersey.servlet.WebConfig;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.ResponseWriter;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;

public class WebComponent {
    private static final Logger LOGGER = Logger.getLogger(WebComponent.class.getName());
    private static final AsyncContextDelegate DefaultAsyncDELEGATE = new AsyncContextDelegate(){

        @Override
        public void suspend(ContainerResponseWriter writer, long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) throws IllegalStateException {
            throw new UnsupportedOperationException("Asynchronous processing not supported on Servlet 2.x container.");
        }

        @Override
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            throw new UnsupportedOperationException("Asynchronous processing not supported on Servlet 2.x container.");
        }

        @Override
        public void complete() {
        }
    };
    final ApplicationHandler appHandler;
    final WebConfig webConfig;
    final boolean forwardOn404;
    private final AsyncContextDelegateProvider asyncExtensionDelegate;

    private AsyncContextDelegateProvider getAsyncExtensionDelegate() {
        Iterator<AsyncContextDelegateProvider> providers = Providers.getAllProviders(this.appHandler.getServiceLocator(), AsyncContextDelegateProvider.class).iterator();
        if (providers.hasNext()) {
            return providers.next();
        }
        return new AsyncContextDelegateProvider(){

            @Override
            public AsyncContextDelegate createDelegate(HttpServletRequest request, HttpServletResponse response) {
                return DefaultAsyncDELEGATE;
            }
        };
    }

    public WebComponent(WebConfig webConfig, ResourceConfig resourceConfig) throws ServletException {
        this.webConfig = webConfig;
        if (resourceConfig == null) {
            resourceConfig = WebComponent.createResourceConfig(webConfig);
        }
        resourceConfig.register(new WebComponentBinder());
        this.appHandler = new ApplicationHandler(resourceConfig);
        this.asyncExtensionDelegate = this.getAsyncExtensionDelegate();
        this.forwardOn404 = webConfig.getConfigType().equals((Object)WebConfig.ConfigType.FilterConfig) && resourceConfig.isProperty("jersey.config.servlet.filter.forwardOn404");
    }

    public Value<Integer> service(URI baseUri, URI requestUri, final HttpServletRequest servletRequest, final HttpServletResponse servletResponse) throws ServletException, IOException {
        ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, servletRequest.getMethod(), this.getSecurityContext(servletRequest), new ServletPropertiesDelegate(servletRequest));
        requestContext.setEntityStream(servletRequest.getInputStream());
        this.addRequestHeaders(servletRequest, requestContext);
        this.filterFormParameters(servletRequest, requestContext);
        try {
            final ResponseWriter responseWriter = new ResponseWriter(this.forwardOn404, servletResponse, this.asyncExtensionDelegate.createDelegate(servletRequest, servletResponse));
            requestContext.setRequestScopedInitializer(new RequestScopedInitializer(){

                @Override
                public void initialize(ServiceLocator locator) {
                    ((Ref)locator.getService(new TypeLiteral<Ref<HttpServletRequest>>(){}.getType(), new Annotation[0])).set(servletRequest);
                    ((Ref)locator.getService(new TypeLiteral<Ref<HttpServletResponse>>(){}.getType(), new Annotation[0])).set(servletResponse);
                }
            });
            requestContext.setWriter(responseWriter);
            this.appHandler.handle(requestContext);
            return Values.lazy(new Value<Integer>(){

                @Override
                public Integer get() {
                    return responseWriter.getResponseStatus();
                }
            });
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    private SecurityContext getSecurityContext(final HttpServletRequest request) {
        return new SecurityContext(){

            @Override
            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            @Override
            public boolean isUserInRole(String role) {
                return request.isUserInRole(role);
            }

            @Override
            public boolean isSecure() {
                return request.isSecure();
            }

            @Override
            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private static ResourceConfig createResourceConfig(WebConfig config) throws ServletException {
        Map<String, Object> initParams = WebComponent.getInitParams(config);
        String jaxrsApplicationClassName = config.getInitParameter("javax.ws.rs.Application");
        if (jaxrsApplicationClassName == null) {
            ResourceConfig rc = new ResourceConfig().addProperties(initParams);
            String webApp = config.getInitParameter("jersey.config.servlet.provider.webapp");
            if (webApp != null && !"false".equals(webApp)) {
                rc.registerFinder(new WebAppResourcesScanner(config.getServletContext()));
            }
            return rc;
        }
        try {
            Class jaxrsApplicationClass = ReflectionHelper.classForNameWithException(jaxrsApplicationClassName);
            if (Application.class.isAssignableFrom(jaxrsApplicationClass)) {
                return ResourceConfig.forApplicationClass(jaxrsApplicationClass).addProperties(initParams);
            }
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_PARENT_CLASS_INVALID(jaxrsApplicationClassName, Application.class));
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_UNABLE_TO_LOAD(jaxrsApplicationClassName), e);
        }
    }

    private void addRequestHeaders(HttpServletRequest request, ContainerRequest requestContext) {
        Enumeration<String> names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Enumeration<String> values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                requestContext.header(name, values.nextElement());
            }
        }
    }

    private static Map<String, Object> getInitParams(WebConfig webConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = webConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, webConfig.getInitParameter(name));
        }
        return props;
    }

    private void filterFormParameters(HttpServletRequest hsr, ContainerRequest request) throws IOException {
        if (MediaTypes.typeEqual(MediaType.APPLICATION_FORM_URLENCODED_TYPE, request.getMediaType()) && !request.hasEntity()) {
            Form f = new Form();
            Enumeration<String> e = hsr.getParameterNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                String[] values = hsr.getParameterValues(name);
                f.asMap().put(name, (String)((Object)Arrays.asList(values)));
            }
            if (!f.asMap().isEmpty()) {
                request.setProperty("jersey.config.server.representation.decoded.form", f);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.FORM_PARAM_CONSUMED(request.getRequestUri()));
                }
            }
        }
    }

    private static class HttpServletRequestReferencingFactory
    extends ReferencingFactory<HttpServletRequest> {
        @Inject
        public HttpServletRequestReferencingFactory(Provider<Ref<HttpServletRequest>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class HttpServletResponseReferencingFactory
    extends ReferencingFactory<HttpServletResponse> {
        @Inject
        public HttpServletResponseReferencingFactory(Provider<Ref<HttpServletResponse>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private class WebComponentBinder
    extends AbstractBinder {
        private WebComponentBinder() {
        }

        @Override
        protected void configure() {
            this.bindFactory(HttpServletRequestReferencingFactory.class).to(HttpServletRequest.class).in(PerLookup.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<HttpServletRequest>>(){}).in(RequestScoped.class);
            this.bindFactory(HttpServletResponseReferencingFactory.class).to(HttpServletResponse.class).in(PerLookup.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<HttpServletResponse>>(){}).in(RequestScoped.class);
            this.bindFactory(new Factory<ServletContext>(){

                @Override
                public ServletContext provide() {
                    return WebComponent.this.webConfig.getServletContext();
                }

                @Override
                public void dispose(ServletContext instance) {
                }
            }).to(ServletContext.class).in(Singleton.class);
            if (WebComponent.this.webConfig.getConfigType() == WebConfig.ConfigType.ServletConfig) {
                this.bindFactory(new Factory<ServletConfig>(){

                    @Override
                    public ServletConfig provide() {
                        return WebComponent.this.webConfig.getServletConfig();
                    }

                    @Override
                    public void dispose(ServletConfig instance) {
                    }
                }).to(ServletConfig.class).in(Singleton.class);
            } else {
                this.bindFactory(new Factory<FilterConfig>(){

                    @Override
                    public FilterConfig provide() {
                        return WebComponent.this.webConfig.getFilterConfig();
                    }

                    @Override
                    public void dispose(FilterConfig instance) {
                    }
                }).to(FilterConfig.class).in(Singleton.class);
            }
            this.bindFactory(new Factory<WebConfig>(){

                @Override
                public WebConfig provide() {
                    return WebComponent.this.webConfig;
                }

                @Override
                public void dispose(WebConfig instance) {
                }
            }).to(WebConfig.class).in(Singleton.class);
            this.install(new ServiceFinderBinder<AsyncContextDelegateProvider>(AsyncContextDelegateProvider.class));
        }
    }
}

