/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.validation.ValidationConfiguration;
import org.glassfish.jersey.server.validation.internal.ConfiguredValidatorImpl;
import org.glassfish.jersey.server.validation.internal.InjectingConstraintValidatorFactory;

public class ValidationBinder
extends AbstractBinder {
    @Override
    protected void configure() {
        this.bindFactory(DefaultValidatorFactoryProvider.class, Singleton.class).to(ValidatorFactory.class).in(PerLookup.class);
        this.bindFactory(DefaultValidatorProvider.class, Singleton.class).to(Validator.class).in(PerLookup.class);
        this.bindFactory(ConfiguredValidatorProvider.class, Singleton.class).to(ConfiguredValidator.class).in(PerLookup.class);
    }

    private static class ConfiguredValidatorProvider
    implements Factory<ConfiguredValidator> {
        @Inject
        private ValidatorFactory factory;
        @Context
        private Providers providers;
        @Context
        private ResourceContext resourceContext;

        private ConfiguredValidatorProvider() {
        }

        @Override
        public ConfiguredValidator provide() {
            return this.getConfiguredValidator(this.factory);
        }

        @Override
        public void dispose(ConfiguredValidator instance) {
        }

        private ConfiguredValidator getConfiguredValidator(ValidatorFactory factory) {
            ValidationConfiguration config;
            ValidatorContext context = factory.usingContext();
            context.constraintValidatorFactory(this.resourceContext.getResource(InjectingConstraintValidatorFactory.class));
            ContextResolver<ValidationConfiguration> contextResolver = this.providers.getContextResolver(ValidationConfiguration.class, MediaType.WILDCARD_TYPE);
            if (contextResolver != null && (config = contextResolver.getContext(ValidationConfiguration.class)) != null) {
                if (config.getMessageInterpolator() != null) {
                    context.messageInterpolator(config.getMessageInterpolator());
                }
                if (config.getTraversableResolver() != null) {
                    context.traversableResolver(config.getTraversableResolver());
                }
                if (config.getConstraintValidatorFactory() != null) {
                    context.constraintValidatorFactory(config.getConstraintValidatorFactory());
                }
                if (config.getParameterNameProvider() != null) {
                    context.parameterNameProvider(config.getParameterNameProvider());
                }
            }
            return new ConfiguredValidatorImpl(context.getValidator());
        }
    }

    private static class DefaultValidatorFactoryProvider
    implements Factory<ValidatorFactory> {
        private final boolean inOsgi = ReflectionHelper.getOsgiRegistryInstance() != null;

        @Override
        public ValidatorFactory provide() {
            if (!this.inOsgi) {
                return Validation.buildDefaultValidatorFactory();
            }
            return Validation.byDefaultProvider().providerResolver(new ValidationProviderResolver(){

                @Override
                public List<ValidationProvider<?>> getValidationProviders() {
                    ArrayList validationProviders = new ArrayList();
                    for (ValidationProvider validationProvider : ServiceFinder.find(ValidationProvider.class)) {
                        validationProviders.add(validationProvider);
                    }
                    return validationProviders;
                }
            }).configure().buildValidatorFactory();
        }

        @Override
        public void dispose(ValidatorFactory instance) {
        }
    }

    private static class DefaultValidatorProvider
    implements Factory<Validator> {
        @Inject
        private ValidatorFactory factory;

        private DefaultValidatorProvider() {
        }

        @Override
        public Validator provide() {
            return this.factory.getValidator();
        }

        @Override
        public void dispose(Validator instance) {
        }
    }
}

