/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.AbstractResourceModelVisitor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.uri.PathPattern;

class ResourceModelValidator
extends AbstractResourceModelVisitor {
    ResourceModelValidator() {
    }

    @Override
    public void visitResourceModel(ResourceModel resourceModel) {
        HashMap<PathPattern, Resource> resourceMap = Maps.newHashMap();
        for (Resource resource : resourceModel.getResources()) {
            PathPattern pathPattern = resource.getPathPattern();
            Resource resourceFromMap = (Resource)resourceMap.get(pathPattern);
            if (resourceFromMap != null) {
                Errors.error(resource, LocalizationMessages.RESOURCE_AMBIGUOUS(resource, resourceFromMap, pathPattern), true);
            }
            resourceMap.put(pathPattern, resource);
        }
    }
}

