/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

public final class ResourceModelIssue {
    private final Object source;
    private final String message;
    private final boolean fatal;

    public ResourceModelIssue(Object source, String message) {
        this(source, message, false);
    }

    public ResourceModelIssue(Object source, String message, boolean isFatal) {
        this.source = source;
        this.message = message;
        this.fatal = isFatal;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public Object getSource() {
        return this.source;
    }

    public String toString() {
        return this.fatal ? "[FATAL] " : "[NON-FATAL] " + this.message + "; source=" + this.source + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceModelIssue other = (ResourceModelIssue)obj;
        if (!(this.source == other.source || this.source != null && this.source.equals(other.source))) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.fatal == other.fatal;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.source != null ? this.source.hashCode() : 0);
        hash = 79 * hash + (this.message != null ? this.message.hashCode() : 0);
        hash = 79 * hash + (this.fatal ? 1 : 0);
        return hash;
    }
}

