/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.AbstractResourceModelVisitor;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.uri.PathPattern;

public class AmbiguousMethodValidator
extends AbstractResourceModelVisitor {
    private final MessageBodyWorkers workers;
    private static final List<MediaType> StarTypeList = Arrays.asList(new MediaType("*", "*"));

    public AmbiguousMethodValidator(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    @Override
    public void visitResource(Resource resource) {
        this.checkConsumesProducesAmbiguities(resource);
    }

    private void checkConsumesProducesAmbiguities(Resource resource) {
        HashMap<PathPattern, List<ResourceMethod>> methodMap = Maps.newHashMap();
        for (Resource resource2 : resource.getChildResources()) {
            if (resource2.getAllMethods().size() <= 0) continue;
            this.getMethodList(methodMap, resource2.getPathPattern()).addAll(resource2.getAllMethods());
        }
        if (resource.getResourceMethods().size() > 0) {
            this.getMethodList(methodMap, null).addAll(resource.getResourceMethods());
        }
        for (Map.Entry entry : methodMap.entrySet()) {
            List methodPaths = (List)entry.getValue();
            if (methodPaths.size() < 2) continue;
            for (ResourceMethod m1 : methodPaths.subList(0, methodPaths.size() - 1)) {
                for (ResourceMethod m2 : methodPaths.subList(methodPaths.indexOf(m1) + 1, methodPaths.size())) {
                    if (m1.getHttpMethod() == null && m2.getHttpMethod() == null) {
                        Errors.error(this, LocalizationMessages.AMBIGUOUS_SRLS_PATH_PATTERN(this, entry.getKey()), true);
                        continue;
                    }
                    if (m1.getHttpMethod() == null || m2.getHttpMethod() == null || !this.sameHttpMethod(m1, m2)) continue;
                    this.checkIntersectingMediaTypes(resource, m1.getHttpMethod(), m1, m2);
                }
            }
        }
    }

    private List<ResourceMethod> getMethodList(Map<PathPattern, List<ResourceMethod>> methodMap, PathPattern pathPattern) {
        List<ResourceMethod> methodList = methodMap.get(pathPattern);
        if (methodList == null) {
            methodList = Lists.newArrayList();
            methodMap.put(pathPattern, methodList);
        }
        return methodList;
    }

    private void checkIntersectingMediaTypes(Resource resource, String httpMethod, ResourceMethod m1, ResourceMethod m2) {
        boolean producesFails;
        boolean consumesFails;
        List<MediaType> inputTypes1 = this.getEffectiveInputTypes(m1);
        List<MediaType> inputTypes2 = this.getEffectiveInputTypes(m2);
        List<MediaType> outputTypes1 = this.getEffectiveOutputTypes(m1);
        List<MediaType> outputTypes2 = this.getEffectiveOutputTypes(m2);
        boolean consumesOnlyIntersects = false;
        if (m1.getConsumedTypes().isEmpty() || m2.getConsumedTypes().isEmpty()) {
            consumesFails = ((Object)inputTypes1).equals(inputTypes2);
            if (!consumesFails) {
                consumesOnlyIntersects = MediaTypes.intersect(inputTypes1, inputTypes2);
            }
        } else {
            consumesFails = MediaTypes.intersect(inputTypes1, inputTypes2);
        }
        boolean producesOnlyIntersects = false;
        if (m1.getProducedTypes().isEmpty() || m2.getProducedTypes().isEmpty()) {
            producesFails = ((Object)outputTypes1).equals(outputTypes2);
            if (!producesFails) {
                producesOnlyIntersects = MediaTypes.intersect(outputTypes1, outputTypes2);
            }
        } else {
            producesFails = MediaTypes.intersect(outputTypes1, outputTypes2);
        }
        if (consumesFails && producesFails) {
            String rcName = resource.getName();
            Errors.fatal(resource, LocalizationMessages.AMBIGUOUS_FATAL_RMS(rcName, httpMethod, m1.getInvocable().getHandlingMethod(), m2.getInvocable().getHandlingMethod()));
        } else if (producesFails && consumesOnlyIntersects || consumesFails && producesOnlyIntersects || consumesOnlyIntersects && producesOnlyIntersects) {
            String rcName = resource.getName();
            if (m1.getInvocable().requiresEntity()) {
                Errors.warning(resource, LocalizationMessages.AMBIGUOUS_RMS_IN(rcName, httpMethod, m1.getInvocable().getHandlingMethod(), m2.getInvocable().getHandlingMethod()));
            } else {
                Errors.warning(resource, LocalizationMessages.AMBIGUOUS_RMS_OUT(rcName, httpMethod, m1.getInvocable().getHandlingMethod(), m2.getInvocable().getHandlingMethod()));
            }
        }
    }

    private List<MediaType> getEffectiveInputTypes(ResourceMethod resourceMethod) {
        if (!resourceMethod.getConsumedTypes().isEmpty()) {
            return resourceMethod.getConsumedTypes();
        }
        LinkedList<MediaType> result = new LinkedList<MediaType>();
        if (this.workers != null) {
            for (Parameter p : resourceMethod.getInvocable().getParameters()) {
                if (p.getSource() != Parameter.Source.ENTITY) continue;
                result.addAll(this.workers.getMessageBodyReaderMediaTypes(p.getRawType(), p.getType(), p.getDeclaredAnnotations()));
            }
        }
        return result.isEmpty() ? StarTypeList : result;
    }

    private List<MediaType> getEffectiveOutputTypes(ResourceMethod resourceMethod) {
        if (!resourceMethod.getProducedTypes().isEmpty()) {
            return resourceMethod.getProducedTypes();
        }
        LinkedList<MediaType> result = new LinkedList<MediaType>();
        if (this.workers != null) {
            Invocable invocable = resourceMethod.getInvocable();
            result.addAll(this.workers.getMessageBodyWriterMediaTypes(invocable.getRawResponseType(), invocable.getResponseType(), invocable.getHandlingMethod().getDeclaredAnnotations()));
        }
        return result.isEmpty() ? StarTypeList : result;
    }

    private boolean sameHttpMethod(ResourceMethod m1, ResourceMethod m2) {
        return m1.getHttpMethod().equals(m2.getHttpMethod());
    }
}

