/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.scanning;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.internal.scanning.FileSchemeResourceFinderFactory;
import org.glassfish.jersey.server.internal.scanning.JarFileScanner;
import org.glassfish.jersey.server.internal.scanning.ResourceFinderException;
import org.glassfish.jersey.server.internal.scanning.ResourceFinderStack;
import org.glassfish.jersey.server.internal.scanning.UriSchemeResourceFinderFactory;

class VfsSchemeResourceFinderFactory
implements UriSchemeResourceFinderFactory {
    @Override
    public Set<String> getSchemes() {
        return new HashSet<String>(Arrays.asList("vfsfile", "vfszip", "vfs"));
    }

    VfsSchemeResourceFinderFactory() {
    }

    @Override
    public VfsSchemeScanner create(URI uri, boolean recursive) {
        ResourceFinderStack resourceFinderStack = new ResourceFinderStack();
        if (!uri.getScheme().equalsIgnoreCase("vfszip")) {
            resourceFinderStack.push(new FileSchemeResourceFinderFactory().create(UriBuilder.fromUri(uri).scheme("file").build(new Object[0]), true));
        } else {
            String su = uri.toString();
            int webInfIndex = su.indexOf("/WEB-INF/classes");
            if (webInfIndex != -1) {
                String war = su.substring(0, webInfIndex);
                String path = su.substring(webInfIndex + 1);
                int warParentIndex = war.lastIndexOf(47);
                String warParent = su.substring(0, warParentIndex);
                if (warParent.endsWith(".ear")) {
                    String warName = su.substring(warParentIndex + 1, war.length());
                    try {
                        JarFileScanner jarFileScanner = new JarFileScanner(new URL(warParent.replace("vfszip", "file")).openStream(), "", true);
                        while (jarFileScanner.hasNext()) {
                            if (!jarFileScanner.next().equals(warName)) continue;
                            resourceFinderStack.push(new JarFileScanner(new FilterInputStream(jarFileScanner.open()){

                                @Override
                                public void close() throws IOException {
                                }
                            }, "", true));
                        }
                    }
                    catch (IOException e) {
                        throw new ResourceFinderException("IO error when scanning war " + uri, e);
                    }
                } else {
                    try {
                        resourceFinderStack.push(new JarFileScanner(new URL(war.replace("vfszip", "file")).openStream(), path, recursive));
                    }
                    catch (IOException e) {
                        throw new ResourceFinderException("IO error when scanning war " + uri, e);
                    }
                }
            } else {
                try {
                    resourceFinderStack.push(new JarFileScanner(new URL(su).openStream(), "", true));
                }
                catch (IOException e) {
                    throw new ResourceFinderException("IO error when scanning jar " + uri, e);
                }
            }
        }
        return new VfsSchemeScanner(resourceFinderStack);
    }

    private class VfsSchemeScanner
    implements ResourceFinder {
        private final ResourceFinderStack resourceFinderStack;

        private VfsSchemeScanner(ResourceFinderStack resourceFinderStack) {
            this.resourceFinderStack = resourceFinderStack;
        }

        @Override
        public boolean hasNext() {
            return this.resourceFinderStack.hasNext();
        }

        @Override
        public String next() {
            return this.resourceFinderStack.next();
        }

        @Override
        public void remove() {
            this.resourceFinderStack.next();
        }

        @Override
        public InputStream open() {
            return this.resourceFinderStack.open();
        }

        @Override
        public void reset() {
            this.resourceFinderStack.reset();
        }
    }
}

