/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.CombinedClientServerMediaType;
import org.glassfish.jersey.server.internal.routing.MethodAcceptorPair;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.Routers;
import org.glassfish.jersey.server.internal.routing.UriRoutingContext;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.wadl.WadlApplicationContext;
import org.jvnet.hk2.annotations.Optional;

final class MethodSelectingRouter
implements Router {
    private static final Logger LOGGER = Logger.getLogger(MethodSelectingRouter.class.getName());
    private final Provider<RespondingContext> respondingContextFactory;
    private final MessageBodyWorkers workers;
    private final Map<String, List<ConsumesProducesAcceptor>> consumesProducesAcceptors;
    private final Router router;
    private final boolean disableWadl;
    private final WadlApplicationContext wadlApplicationContext;

    private MethodSelectingRouter(Provider<RespondingContext> respondingContextFactory, MessageBodyWorkers msgWorkers, List<MethodAcceptorPair> methodAcceptorPairs, boolean disableWadl, WadlApplicationContext wadlApplicationContext) {
        this.respondingContextFactory = respondingContextFactory;
        this.workers = msgWorkers;
        this.disableWadl = disableWadl;
        this.wadlApplicationContext = wadlApplicationContext;
        this.consumesProducesAcceptors = new HashMap<String, List<ConsumesProducesAcceptor>>();
        Resource resource = null;
        for (MethodAcceptorPair methodAcceptorPair : methodAcceptorPairs) {
            String httpMethod = methodAcceptorPair.model.getHttpMethod();
            List<ConsumesProducesAcceptor> httpMethodBoundAcceptors = this.consumesProducesAcceptors.get(httpMethod);
            if (httpMethodBoundAcceptors == null) {
                httpMethodBoundAcceptors = new LinkedList<ConsumesProducesAcceptor>();
                this.consumesProducesAcceptors.put(httpMethod, httpMethodBoundAcceptors);
            }
            this.addAllConsumesProducesCombinations(httpMethodBoundAcceptors, methodAcceptorPair);
            if (methodAcceptorPair.parentResource == null) continue;
            resource = methodAcceptorPair.parentResource;
        }
        this.router = !this.consumesProducesAcceptors.containsKey("HEAD") ? this.createHeadEnrichedRouter() : this.createInternalRouter();
        if (!this.consumesProducesAcceptors.containsKey("OPTIONS")) {
            this.addOptionsSupport(resource);
        }
    }

    private Router createInternalRouter() {
        return new Router(){

            @Override
            public Router.Continuation apply(ContainerRequest requestContext) {
                return Router.Continuation.of(requestContext, MethodSelectingRouter.this.getMethodRouter(requestContext));
            }
        };
    }

    @Override
    public Router.Continuation apply(ContainerRequest requestContext) {
        return this.router.apply(requestContext);
    }

    private void addAllConsumesProducesCombinations(List<ConsumesProducesAcceptor> list, MethodAcceptorPair methodAcceptorPair) {
        LinkedList<MediaType> effectiveInputTypes = new LinkedList<MediaType>();
        ResourceMethod resourceMethod = methodAcceptorPair.model;
        boolean consumesFromWorkers = this.fillMediaTypes(effectiveInputTypes, resourceMethod, resourceMethod.getConsumedTypes(), true);
        LinkedList<MediaType> effectiveOutputTypes = new LinkedList<MediaType>();
        boolean producesFromWorkers = this.fillMediaTypes(effectiveOutputTypes, resourceMethod, resourceMethod.getProducedTypes(), false);
        for (MediaType consumes : effectiveInputTypes) {
            for (MediaType produces : effectiveOutputTypes) {
                list.add(new ConsumesProducesAcceptor(new CombinedClientServerMediaType.EffectiveMediaType(consumes, consumesFromWorkers), new CombinedClientServerMediaType.EffectiveMediaType(produces, producesFromWorkers), methodAcceptorPair));
            }
        }
    }

    private boolean fillMediaTypes(List<MediaType> effectiveTypes, ResourceMethod resourceMethod, List<MediaType> methodTypes, boolean inputTypes) {
        boolean consumesFromWorkers = false;
        effectiveTypes.addAll(methodTypes);
        if (effectiveTypes.isEmpty() && this.workers != null) {
            Invocable invocableMethod = resourceMethod.getInvocable();
            if (inputTypes) {
                this.fillInputTypesFromWorkers(effectiveTypes, invocableMethod);
            } else {
                this.fillOutputParameters(effectiveTypes, invocableMethod);
            }
            boolean bl = consumesFromWorkers = !effectiveTypes.isEmpty();
        }
        if (effectiveTypes.isEmpty()) {
            effectiveTypes.add(MediaType.valueOf("*/*"));
        }
        return consumesFromWorkers;
    }

    private void fillOutputParameters(List<MediaType> effectiveOutputTypes, Invocable invocableMethod) {
        List<MediaType> messageBodyWriterMediaTypes = this.workers.getMessageBodyWriterMediaTypes(invocableMethod.getRawResponseType(), invocableMethod.getResponseType(), invocableMethod.getHandlingMethod().getDeclaredAnnotations());
        effectiveOutputTypes.addAll(messageBodyWriterMediaTypes);
    }

    private void fillInputTypesFromWorkers(List<MediaType> effectiveInputTypes, Invocable invocableMethod) {
        for (Parameter p : invocableMethod.getParameters()) {
            if (p.getSource() != Parameter.Source.ENTITY) continue;
            List<MediaType> messageBodyReaderMediaTypes = this.workers.getMessageBodyReaderMediaTypes(p.getRawType(), p.getType(), p.getDeclaredAnnotations());
            effectiveInputTypes.addAll(messageBodyReaderMediaTypes);
        }
    }

    private Router getMethodRouter(ContainerRequest requestContext) {
        List<ConsumesProducesAcceptor> acceptors = this.consumesProducesAcceptors.get(requestContext.getMethod());
        if (acceptors == null) {
            throw new WebApplicationException(Response.status(Response.Status.METHOD_NOT_ALLOWED).allow(this.consumesProducesAcceptors.keySet()).build());
        }
        LinkedList<ConsumesProducesAcceptor> satisfyingAcceptors = new LinkedList<ConsumesProducesAcceptor>();
        for (ConsumesProducesAcceptor cpi : acceptors) {
            if (!cpi.isConsumable(requestContext)) continue;
            satisfyingAcceptors.add(cpi);
        }
        if (satisfyingAcceptors.isEmpty()) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        List<MediaType> acceptableMediaTypes = requestContext.getAcceptableMediaTypes();
        MethodSelector methodSelector = new MethodSelector(null);
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            for (ConsumesProducesAcceptor satisfiable : satisfyingAcceptors) {
                if (!satisfiable.produces.getMediaType().isCompatible(acceptableMediaType)) continue;
                MediaType requestContentType = requestContext.getMediaType();
                MediaType effectiveContentType = requestContentType == null ? MediaType.WILDCARD_TYPE : requestContentType;
                RequestSpecificConsumesProducesAcceptor candidate = new RequestSpecificConsumesProducesAcceptor(CombinedClientServerMediaType.create(effectiveContentType, satisfiable.getConsumes()), CombinedClientServerMediaType.create(acceptableMediaType, satisfiable.getProduces()), satisfiable.methodAcceptorPair);
                methodSelector.consider(candidate);
            }
        }
        if (methodSelector.selected != null) {
            final RequestSpecificConsumesProducesAcceptor selected = methodSelector.selected;
            if (methodSelector.sameFitnessAcceptors != null) {
                this.reportMethodSelectionAmbiguity(acceptableMediaTypes, selected, methodSelector.sameFitnessAcceptors);
            }
            this.respondingContextFactory.get().push(new Function<ContainerResponse, ContainerResponse>(){

                @Override
                public ContainerResponse apply(ContainerResponse responseContext) {
                    if (responseContext.getMediaType() == null && (responseContext.hasEntity() || "HEAD".equals(responseContext.getRequestContext().getMethod()))) {
                        MediaType effectiveResponseType = selected.produces.getCombinedMediaType();
                        if (MethodSelectingRouter.this.isWildcard(effectiveResponseType)) {
                            if (effectiveResponseType.isWildcardType() || effectiveResponseType.getType().equalsIgnoreCase("application")) {
                                effectiveResponseType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
                            } else {
                                throw new WebApplicationException(Response.status(Response.Status.NOT_ACCEPTABLE).build());
                            }
                        }
                        responseContext.setMediaType(effectiveResponseType);
                    }
                    return responseContext;
                }
            });
            return selected.methodAcceptorPair.router;
        }
        throw new WebApplicationException(Response.status(Response.Status.NOT_ACCEPTABLE).build());
    }

    private boolean isWildcard(MediaType effectiveResponseType) {
        return effectiveResponseType.isWildcardType() || effectiveResponseType.isWildcardSubtype();
    }

    private void reportMethodSelectionAmbiguity(List<MediaType> acceptableTypes, RequestSpecificConsumesProducesAcceptor selected, List<RequestSpecificConsumesProducesAcceptor> sameFitnessAcceptors) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            StringBuilder msgBuilder = new StringBuilder(LocalizationMessages.AMBIGUOUS_RESOURCE_METHOD(acceptableTypes)).append('\n');
            msgBuilder.append('\t').append(selected.methodAcceptorPair.model).append('\n');
            HashSet<ResourceMethod> reportedMethods = Sets.newHashSet();
            reportedMethods.add(selected.methodAcceptorPair.model);
            for (RequestSpecificConsumesProducesAcceptor i : sameFitnessAcceptors) {
                if (!reportedMethods.contains(i.methodAcceptorPair.model)) {
                    msgBuilder.append('\t').append(i.methodAcceptorPair.model).append('\n');
                }
                reportedMethods.add(i.methodAcceptorPair.model);
            }
            LOGGER.log(Level.WARNING, msgBuilder.toString());
        }
    }

    private void addOptionsSupport(Resource resource) {
        HashSet<String> allowedMethods = new HashSet<String>(this.consumesProducesAcceptors.keySet());
        allowedMethods.add("HEAD");
        allowedMethods.add("OPTIONS");
        LinkedList<ConsumesProducesAcceptor> optionsAcceptors = new LinkedList<ConsumesProducesAcceptor>();
        optionsAcceptors.add(this.createPlainTextOptionsEndpoint(allowedMethods));
        optionsAcceptors.add(this.createGenericOptionsEndpoint(allowedMethods));
        if (!this.disableWadl && this.wadlApplicationContext != null) {
            optionsAcceptors.add(this.createWadlOptionsEndpoint(resource, allowedMethods, this.wadlApplicationContext));
        }
        this.consumesProducesAcceptors.put("OPTIONS", optionsAcceptors);
    }

    private Router createHeadEnrichedRouter() {
        return new Router(){

            @Override
            public Router.Continuation apply(ContainerRequest requestContext) {
                if ("HEAD".equals(requestContext.getMethod())) {
                    requestContext.setMethodWithoutException("GET");
                    ((RespondingContext)MethodSelectingRouter.this.respondingContextFactory.get()).push(new Function<ContainerResponse, ContainerResponse>(){

                        @Override
                        public ContainerResponse apply(ContainerResponse responseContext) {
                            responseContext.getRequestContext().setMethodWithoutException("HEAD");
                            return responseContext;
                        }
                    });
                }
                return Router.Continuation.of(requestContext, MethodSelectingRouter.this.getMethodRouter(requestContext));
            }
        };
    }

    private ConsumesProducesAcceptor createPlainTextOptionsEndpoint(final Set<String> allowedMethods) {
        String allowedList = allowedMethods.toString();
        final String optionsBody = allowedList.substring(1, allowedList.length() - 1);
        return new ConsumesProducesAcceptor(new CombinedClientServerMediaType.EffectiveMediaType(MediaType.WILDCARD_TYPE, false), new CombinedClientServerMediaType.EffectiveMediaType(MediaType.TEXT_PLAIN_TYPE, false), new MethodAcceptorPair(null, null, Routers.asTreeAcceptor(new Endpoint(){

            @Override
            public ContainerResponse apply(ContainerRequest requestContext) {
                Response response = Response.ok((Object)optionsBody, MediaType.TEXT_PLAIN_TYPE).allow(allowedMethods).build();
                return new ContainerResponse(requestContext, response);
            }
        })));
    }

    private ConsumesProducesAcceptor createGenericOptionsEndpoint(final Set<String> allowedMethods) {
        return new ConsumesProducesAcceptor(new CombinedClientServerMediaType.EffectiveMediaType(MediaType.WILDCARD_TYPE, false), new CombinedClientServerMediaType.EffectiveMediaType(MediaType.WILDCARD_TYPE, false), new MethodAcceptorPair(null, null, Routers.asTreeAcceptor(new Endpoint(){

            @Override
            public ContainerResponse apply(ContainerRequest requestContext) {
                Response response = Response.ok().allow(allowedMethods).header("Content-Length", "0").type(requestContext.getAcceptableMediaTypes().get(0)).build();
                return new ContainerResponse(requestContext, response);
            }
        })));
    }

    private ConsumesProducesAcceptor createWadlOptionsEndpoint(final Resource resource, final Set<String> allowedMethods, final WadlApplicationContext wadlApplicationContext) {
        return new ConsumesProducesAcceptor(new CombinedClientServerMediaType.EffectiveMediaType(MediaTypes.WADL, false), new CombinedClientServerMediaType.EffectiveMediaType(MediaTypes.WADL, false), new MethodAcceptorPair(null, null, Routers.asTreeAcceptor(new Endpoint(){
            private final String lastModified = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date());

            @Override
            public ContainerResponse apply(ContainerRequest requestContext) {
                Response response;
                if (wadlApplicationContext == null || resource == null) {
                    response = Response.ok().allow(allowedMethods).header("Content-Length", "0").type(requestContext.getAcceptableMediaTypes().get(0)).build();
                } else {
                    String lastMatchedPathSegment = ((UriRoutingContext)requestContext.getUriInfo()).getMatchedTemplates().get(0).getTemplate().substring(1);
                    Resource resourceForWadlModel = null;
                    if (lastMatchedPathSegment.equals("") || lastMatchedPathSegment.equals(resource.getPath())) {
                        resourceForWadlModel = resource;
                    } else {
                        for (Resource childResource : resource.getChildResources()) {
                            if (!childResource.getPath().equals(lastMatchedPathSegment) && !childResource.getPath().equals("/" + lastMatchedPathSegment)) continue;
                            resourceForWadlModel = childResource;
                            break;
                        }
                    }
                    response = Response.ok().allow(allowedMethods).type(MediaTypes.WADL).header("Last-modified", this.lastModified).entity(wadlApplicationContext.getApplication(requestContext.getUriInfo(), resourceForWadlModel)).build();
                }
                return new ContainerResponse(requestContext, response);
            }
        })));
    }

    static class Builder {
        @Inject
        private Provider<RespondingContext> respondingContextFactory;
        @Inject
        @Optional
        private Configuration config;
        @Inject
        @Optional
        private WadlApplicationContext wadlApplicationContext;

        Builder() {
        }

        public MethodSelectingRouter build(MessageBodyWorkers workers, List<MethodAcceptorPair> methodAcceptorPairs) {
            return new MethodSelectingRouter(this.respondingContextFactory, workers, methodAcceptorPairs, PropertiesHelper.isProperty(this.config.getProperty("jersey.config.server.wadl.disableWadl")), this.wadlApplicationContext);
        }
    }

    private static class ConsumesProducesAcceptor {
        private CombinedClientServerMediaType.EffectiveMediaType consumes;
        private CombinedClientServerMediaType.EffectiveMediaType produces;
        private MethodAcceptorPair methodAcceptorPair;

        private ConsumesProducesAcceptor(CombinedClientServerMediaType.EffectiveMediaType consumes, CombinedClientServerMediaType.EffectiveMediaType produces, MethodAcceptorPair methodAcceptorPair) {
            this.methodAcceptorPair = methodAcceptorPair;
            this.consumes = consumes;
            this.produces = produces;
        }

        public CombinedClientServerMediaType.EffectiveMediaType getConsumes() {
            return this.consumes;
        }

        public CombinedClientServerMediaType.EffectiveMediaType getProduces() {
            return this.produces;
        }

        boolean isConsumable(ContainerRequest requestContext) {
            MediaType contentType = requestContext.getMediaType();
            return contentType == null || this.consumes.getMediaType().isCompatible(contentType);
        }

        public String toString() {
            return String.format("%s->%s:%s", this.consumes.getMediaType(), this.produces.getMediaType(), this.methodAcceptorPair);
        }
    }

    private static class MethodSelector {
        RequestSpecificConsumesProducesAcceptor selected;
        List<RequestSpecificConsumesProducesAcceptor> sameFitnessAcceptors;

        MethodSelector(RequestSpecificConsumesProducesAcceptor i) {
            this.selected = i;
            this.sameFitnessAcceptors = null;
        }

        void consider(RequestSpecificConsumesProducesAcceptor i) {
            int theGreaterTheBetter = i.compareTo(this.selected);
            if (theGreaterTheBetter > 0) {
                this.selected = i;
                this.sameFitnessAcceptors = null;
            } else if (theGreaterTheBetter == 0 && this.selected.methodAcceptorPair != i.methodAcceptorPair) {
                this.getSameFitnessList().add(i);
            }
        }

        List<RequestSpecificConsumesProducesAcceptor> getSameFitnessList() {
            if (this.sameFitnessAcceptors == null) {
                this.sameFitnessAcceptors = new LinkedList<RequestSpecificConsumesProducesAcceptor>();
            }
            return this.sameFitnessAcceptors;
        }
    }

    private static class RequestSpecificConsumesProducesAcceptor
    implements Comparable {
        CombinedClientServerMediaType consumes;
        CombinedClientServerMediaType produces;
        MethodAcceptorPair methodAcceptorPair;

        RequestSpecificConsumesProducesAcceptor(CombinedClientServerMediaType consumes, CombinedClientServerMediaType produces, MethodAcceptorPair methodAcceptorPair) {
            this.methodAcceptorPair = methodAcceptorPair;
            this.consumes = consumes;
            this.produces = produces;
        }

        public String toString() {
            return String.format("%s->%s:%s", this.consumes, this.produces, this.methodAcceptorPair);
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (!(o instanceof RequestSpecificConsumesProducesAcceptor)) {
                return 1;
            }
            RequestSpecificConsumesProducesAcceptor other = (RequestSpecificConsumesProducesAcceptor)o;
            int consumedComparison = CombinedClientServerMediaType.COMPARATOR.compare(this.consumes, other.consumes);
            return consumedComparison != 0 ? consumedComparison : CombinedClientServerMediaType.COMPARATOR.compare(this.produces, other.produces);
        }
    }
}

