/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.CollectionExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamConverterFactory;
import org.glassfish.jersey.server.internal.inject.PrimitiveMapper;
import org.glassfish.jersey.server.internal.inject.PrimitiveValueOfExtractor;
import org.glassfish.jersey.server.internal.inject.SingleStringValueExtractor;
import org.glassfish.jersey.server.internal.inject.SingleValueExtractor;
import org.glassfish.jersey.server.internal.inject.StringCollectionExtractor;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class MultivaluedParameterExtractorFactory
implements MultivaluedParameterExtractorProvider {
    private final ParamConverterFactory paramConverterFactory;

    @Inject
    public MultivaluedParameterExtractorFactory(ParamConverterFactory stringReaderFactory) {
        this.paramConverterFactory = stringReaderFactory;
    }

    @Override
    public MultivaluedParameterExtractor<?> getWithoutDefaultValue(Parameter p) {
        return this.process(this.paramConverterFactory, null, p.getRawType(), p.getType(), p.getAnnotations(), p.getSourceName());
    }

    @Override
    public MultivaluedParameterExtractor<?> get(Parameter p) {
        return this.process(this.paramConverterFactory, p.getDefaultValue(), p.getRawType(), p.getType(), p.getAnnotations(), p.getSourceName());
    }

    private MultivaluedParameterExtractor<?> process(ParamConverterFactory paramConverterFactory, String defaultValue, Class<?> rawType, Type type2, Annotation[] annotations, String parameterName) {
        if (rawType == List.class || rawType == Set.class || rawType == SortedSet.class) {
            ClassTypePair ctp;
            List<ClassTypePair> ctps = ReflectionHelper.getTypeArgumentAndClass(type2);
            ClassTypePair classTypePair = ctp = ctps.size() == 1 ? ctps.get(0) : null;
            if (ctp == null || ctp.rawClass() == String.class) {
                return StringCollectionExtractor.getInstance(rawType, parameterName, defaultValue);
            }
            ParamConverter<?> converter = paramConverterFactory.getConverter(ctp.rawClass(), ctp.type(), annotations);
            if (converter == null) {
                return null;
            }
            try {
                return CollectionExtractor.getInstance(rawType, converter, parameterName, defaultValue);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not process parameter type " + rawType, e);
            }
        }
        ParamConverter<?> converter = paramConverterFactory.getConverter(rawType, type2, annotations);
        if (converter != null) {
            try {
                return new SingleValueExtractor(converter, parameterName, defaultValue);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not process parameter type " + rawType, e);
            }
        }
        if (rawType == String.class) {
            return new SingleStringValueExtractor(parameterName, defaultValue);
        }
        if (rawType.isPrimitive()) {
            if ((rawType = PrimitiveMapper.primitiveToClassMap.get(rawType)) == null) {
                return null;
            }
            Method valueOf = ReflectionHelper.getValueOfStringMethod(rawType);
            if (valueOf != null) {
                try {
                    Object defaultDefaultValue = PrimitiveMapper.primitiveToDefaultValueMap.get(rawType);
                    return new PrimitiveValueOfExtractor(valueOf, parameterName, defaultValue, defaultDefaultValue);
                }
                catch (Exception e) {
                    throw new ProcessingException(LocalizationMessages.DEFAULT_COULD_NOT_PROCESS_METHOD(defaultValue, valueOf));
                }
            }
        }
        return null;
    }
}

