/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.InterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.JSONP;

@BindingPriority(value=5000)
public class JsonWithPaddingInterceptor
implements WriterInterceptor {
    private final Map<String, Set<String>> javascriptTypes;
    private Provider<ContainerRequest> containerRequestProvider;

    @Inject
    public JsonWithPaddingInterceptor(Provider<ContainerRequest> containerRequestProvider) {
        this.containerRequestProvider = containerRequestProvider;
        this.javascriptTypes = new HashMap<String, Set<String>>();
        this.javascriptTypes.put("application", new HashSet<String>(Arrays.asList("x-javascript", "ecmascript", "javascript")));
        this.javascriptTypes.put("text", new HashSet<String>(Arrays.asList("javascript", "x-javascript", "ecmascript", "jscript")));
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        boolean isJavascript = this.isJavascript(context.getMediaType());
        if (isJavascript) {
            context.setMediaType(MediaType.APPLICATION_JSON_TYPE);
            context.getOutputStream().write(this.getCallbackName(context).getBytes());
            context.getOutputStream().write(40);
        }
        context.proceed();
        if (isJavascript) {
            context.getOutputStream().write(41);
        }
    }

    private boolean isJavascript(MediaType m) {
        if (m == null) {
            return false;
        }
        Set<String> subtypes = this.javascriptTypes.get(m.getType());
        return subtypes != null && subtypes.contains(m.getSubtype());
    }

    private String getCallbackName(InterceptorContext context) {
        String callback = "callback";
        JSONP jsonp = this.getJsonpAnnotation(context);
        if (jsonp != null) {
            callback = jsonp.callback();
            if (!"".equals(jsonp.queryParam())) {
                ContainerRequest containerRequest = this.containerRequestProvider.get();
                UriInfo uriInfo = containerRequest.getUriInfo();
                MultivaluedMap<String, String> queryParameters = uriInfo.getQueryParameters();
                List queryParameter = (List)queryParameters.get(jsonp.queryParam());
                callback = queryParameter != null && !queryParameter.isEmpty() ? (String)queryParameter.get(0) : callback;
            }
        }
        return callback;
    }

    private JSONP getJsonpAnnotation(InterceptorContext context) {
        Annotation[] annotations = context.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof JSONP)) continue;
                return (JSONP)annotation;
            }
        }
        return null;
    }
}

