/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractFuture;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.ws.rs.NameBinding;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerMessageBodyWorkersInitializer;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.ResourceBag;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBinder;
import org.glassfish.jersey.server.ServerConfig;
import org.glassfish.jersey.server.ServerRuntime;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.RoutedInflectorExtractorStage;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingStage;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.ComponentModelValidator;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.internal.ModelErrors;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.wadl.WadlApplicationContext;
import org.glassfish.jersey.server.wadl.internal.WadlApplicationContextImpl;
import org.glassfish.jersey.server.wadl.internal.WadlResource;

public final class ApplicationHandler {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        @Override
        public boolean isUserInRole(String role) {
            return false;
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }

        @Override
        public String getAuthenticationScheme() {
            return null;
        }
    };
    private final Application application;
    private final ResourceConfig runtimeConfig;
    private final ServiceLocator locator = Injections.createLocator(new ServerBinder(), new ApplicationBinder());
    private ServerRuntime runtime;

    public ApplicationHandler() {
        this(new Application());
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        this.application = this.createApplication(jaxrsApplicationClass);
        this.runtimeConfig = ResourceConfig.createRuntimeConfig(this.application);
        Errors.processWithException(new Runnable(){

            @Override
            public void run() {
                ApplicationHandler.this.initialize();
            }
        });
    }

    public ApplicationHandler(Application application) {
        ResourceConfig rc;
        this.application = application;
        if (application instanceof ResourceConfig && (rc = (ResourceConfig)application).getApplicationClass() != null) {
            rc.setApplication(this.createApplication(rc.getApplicationClass()));
        }
        this.runtimeConfig = ResourceConfig.createRuntimeConfig(application);
        Errors.processWithException(new Runnable(){

            @Override
            public void run() {
                ApplicationHandler.this.initialize();
            }
        });
    }

    private Application createApplication(Class<? extends Application> applicationClass) {
        ResourceConfig _rc;
        Class<? extends Application> innerAppClass;
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        Application app = this.locator.createAndInitialize(applicationClass);
        if (app instanceof ResourceConfig && (innerAppClass = (_rc = (ResourceConfig)app).getApplicationClass()) != null) {
            Application innerApp = this.createApplication(innerAppClass);
            _rc.setApplication(innerApp);
        }
        return app;
    }

    private void initialize() {
        Resource resource;
        LOGGER.info(LocalizationMessages.INIT_MSG(Version.getBuildId()));
        if (this.application instanceof ResourceConfig) {
            ((ResourceConfig)this.application).lock();
        }
        this.runtimeConfig.configureMetaProviders(this.locator);
        boolean wadlDisabled = this.runtimeConfig.isProperty("jersey.config.server.wadl.disableWadl");
        if (!wadlDisabled && !this.runtimeConfig.isRegistered(WadlResource.class)) {
            this.runtimeConfig.register((Class)WadlResource.class);
        }
        ResourceBag.Builder resourceBagBuilder = new ResourceBag.Builder();
        for (Class<?> c : this.runtimeConfig.getClasses()) {
            try {
                resource = Resource.from(c);
                if (resource == null) continue;
                resourceBagBuilder.registerResource(c, resource);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (Object o : this.runtimeConfig.getSingletons()) {
            try {
                resource = Resource.from(o.getClass());
                if (resource == null) continue;
                resourceBagBuilder.registerResource(o, resource);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (Resource programmaticResource : this.runtimeConfig.getResources()) {
            resourceBagBuilder.registerProgrammaticResource(programmaticResource);
        }
        ResourceBag resourceBag = resourceBagBuilder.build();
        this.runtimeConfig.lock();
        HashSet<ComponentProvider> componentProviders = new HashSet<ComponentProvider>();
        for (ComponentProvider provider : ServiceFinder.find(ComponentProvider.class)) {
            provider.initialize(this.locator);
            componentProviders.add(provider);
        }
        ComponentBag componentBag = this.runtimeConfig.getComponentBag();
        this.bindProvidersAndResources(componentProviders, componentBag, resourceBag);
        for (ComponentProvider componentProvider : componentProviders) {
            componentProvider.done();
        }
        Collection<Class<? extends Annotation>> applicationNameBindings = ReflectionHelper.getAnnotationTypes(this.application.getClass(), NameBinding.class);
        Iterable<RankedProvider<ContainerResponseFilter>> responseFilters = Providers.getAllRankedProviders(this.locator, ContainerResponseFilter.class);
        MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerResponseFilter>> nameBoundResponseFilters = ApplicationHandler.filterNameBound(responseFilters, null, componentBag, applicationNameBindings);
        Iterable<RankedProvider<ContainerRequestFilter>> requestFilters = Providers.getAllRankedProviders(this.locator, ContainerRequestFilter.class);
        ArrayList<RankedProvider<ContainerRequestFilter>> preMatchFilters = Lists.newArrayList();
        MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerRequestFilter>> nameBoundRequestFilters = ApplicationHandler.filterNameBound(requestFilters, preMatchFilters, componentBag, applicationNameBindings);
        Iterable<RankedProvider<ReaderInterceptor>> readerInterceptors = Providers.getAllRankedProviders(this.locator, ReaderInterceptor.class);
        MultivaluedMap<Class<? extends Annotation>, RankedProvider<ReaderInterceptor>> nameBoundReaderInterceptors = ApplicationHandler.filterNameBound(readerInterceptors, null, componentBag, applicationNameBindings);
        Iterable<RankedProvider<WriterInterceptor>> writerInterceptors = Providers.getAllRankedProviders(this.locator, WriterInterceptor.class);
        MultivaluedMap<Class<? extends Annotation>, RankedProvider<WriterInterceptor>> nameBoundWriterInterceptors = ApplicationHandler.filterNameBound(writerInterceptors, null, componentBag, applicationNameBindings);
        Iterable<DynamicFeature> dynamicFeatures = Providers.getAllProviders(this.locator, DynamicFeature.class);
        this.validate(resourceBag.models);
        DynamicConfiguration dynamicConfiguration = Injections.getConfiguration(this.locator);
        Injections.addBinding(Injections.newBinder(new WadlApplicationContextImpl(resourceBag.getRootResources(), this.runtimeConfig)).to(WadlApplicationContext.class), dynamicConfiguration);
        dynamicConfiguration.commit();
        RuntimeModelBuilder runtimeModelBuilder = this.locator.getService(RuntimeModelBuilder.class, new Annotation[0]);
        runtimeModelBuilder.setGlobalInterceptors(readerInterceptors, writerInterceptors);
        runtimeModelBuilder.setBoundProviders(nameBoundRequestFilters, nameBoundResponseFilters, nameBoundReaderInterceptors, nameBoundWriterInterceptors, dynamicFeatures);
        for (Resource resource2 : resourceBag.models) {
            runtimeModelBuilder.process(resource2, false);
        }
        Router resourceRoutingRoot = runtimeModelBuilder.buildModel(false);
        ContainerFilteringStage preMatchRequestFilteringStage = this.locator.createAndInitialize(ContainerFilteringStage.Builder.class).build(preMatchFilters, responseFilters);
        RoutingStage routingStage = this.locator.createAndInitialize(RoutingStage.Builder.class).build(resourceRoutingRoot);
        ContainerFilteringStage resourceFilteringStage = this.locator.createAndInitialize(ContainerFilteringStage.Builder.class).build(requestFilters, null);
        RoutedInflectorExtractorStage routedInflectorExtractorStage = this.locator.createAndInitialize(RoutedInflectorExtractorStage.class);
        Stage<ContainerRequest> rootStage = Stages.chain(this.locator.createAndInitialize(ReferencesInitializer.class)).to(this.locator.createAndInitialize(ContainerMessageBodyWorkersInitializer.class)).to(preMatchRequestFilteringStage).to(routingStage).to(resourceFilteringStage).build(routedInflectorExtractorStage);
        for (Object instance : componentBag.getInstances(ComponentBag.EXCLUDE_META_PROVIDERS)) {
            this.locator.inject(instance);
        }
        for (Object instance : resourceBag.instances) {
            this.locator.inject(instance);
        }
        this.runtime = this.locator.createAndInitialize(ServerRuntime.Builder.class).build(rootStage);
        this.locator.inject(this);
    }

    private static <T> MultivaluedMap<Class<? extends Annotation>, RankedProvider<T>> filterNameBound(Iterable<RankedProvider<T>> all, Collection<RankedProvider<ContainerRequestFilter>> preMatching, ComponentBag componentBag, Collection<Class<? extends Annotation>> applicationNameBindings) {
        MultivaluedHashMap<Class<Annotation>, RankedProvider<T>> result = new MultivaluedHashMap<Class<Annotation>, RankedProvider<T>>();
        Iterator<RankedProvider<T>> it = all.iterator();
        while (it.hasNext()) {
            boolean nameBound;
            RankedProvider<T> provider = it.next();
            Class<?> providerClass = provider.getProvider().getClass();
            ContractProvider model = componentBag.getModel(providerClass);
            if (model == null) {
                model = ComponentBag.modelFor(providerClass);
            }
            if (preMatching != null && providerClass.getAnnotation(PreMatching.class) != null) {
                it.remove();
                preMatching.add(new RankedProvider<ContainerRequestFilter>((ContainerRequestFilter)provider.getProvider(), model.getPriority(ContainerRequestFilter.class)));
            }
            if ((nameBound = model.isNameBound()) && !applicationNameBindings.isEmpty()) {
                for (Class binding : model.getNameBindings()) {
                    if (!applicationNameBindings.contains(binding)) continue;
                    nameBound = false;
                    break;
                }
            }
            if (!nameBound) continue;
            it.remove();
            for (Class binding : model.getNameBindings()) {
                result.add(binding, provider);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void bindProvidersAndResources(Set<ComponentProvider> componentProviders, final ComponentBag componentBag, final ResourceBag resourceBag) {
        JerseyResourceContext resourceContext = this.locator.getService(JerseyResourceContext.class, new Annotation[0]);
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        final Set<Class<?>> registeredClasses = this.runtimeConfig.getRegisteredClasses();
        Set<Class<?>> classes = Sets.newIdentityHashSet();
        classes.addAll(Sets.filter(componentBag.getClasses(ComponentBag.EXCLUDE_META_PROVIDERS), new Predicate<Class<?>>(){

            @Override
            public boolean apply(Class<?> componentClass) {
                return Providers.checkProviderRuntime(componentClass, componentBag.getModel(componentClass), RuntimeType.SERVER, !registeredClasses.contains(componentClass), resourceBag.classes.contains(componentClass));
            }
        }));
        classes.addAll(resourceBag.classes);
        for (Class clazz : classes) {
            ContractProvider contractProvider = componentBag.getModel(clazz);
            if (resourceBag.classes.contains(clazz)) {
                void var10_11;
                if (this.bindWithComponentProvider(clazz, contractProvider, componentProviders)) continue;
                if (!Resource.isAcceptable(clazz)) {
                    LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_COMPONENT(clazz));
                    continue;
                }
                if (contractProvider != null && !Providers.checkProviderRuntime(clazz, contractProvider, RuntimeType.SERVER, !registeredClasses.contains(clazz), true)) {
                    Object var10_13 = null;
                }
                resourceContext.unsafeBindResource(clazz, (ContractProvider)var10_11, dc);
                continue;
            }
            ProviderBinder.bindProvider(clazz, contractProvider, dc);
        }
        HashSet<Object> instances = Sets.newHashSet();
        instances.addAll(Sets.filter(componentBag.getInstances(ComponentBag.EXCLUDE_META_PROVIDERS), new Predicate<Object>(){

            @Override
            public boolean apply(Object component) {
                Class<?> componentClass = component.getClass();
                return Providers.checkProviderRuntime(componentClass, componentBag.getModel(componentClass), RuntimeType.SERVER, !registeredClasses.contains(componentClass), resourceBag.instances.contains(component));
            }
        }));
        instances.addAll(resourceBag.instances);
        for (Object e : instances) {
            ContractProvider model = componentBag.getModel(e.getClass());
            if (resourceBag.instances.contains(e)) {
                if (model != null && !Providers.checkProviderRuntime(e.getClass(), model, RuntimeType.SERVER, !registeredClasses.contains(e.getClass()), true)) {
                    model = null;
                }
                resourceContext.unsafeBindResource(e, model, dc);
                continue;
            }
            ProviderBinder.bindProvider(e, model, dc);
        }
        dc.commit();
    }

    private boolean bindWithComponentProvider(Class<?> component, ContractProvider providerModel, Collection<ComponentProvider> componentProviders) {
        Set<Class<?>> contracts = providerModel == null ? Collections.emptySet() : providerModel.getContracts();
        for (ComponentProvider provider : componentProviders) {
            if (!provider.bind(component, contracts)) continue;
            return true;
        }
        return false;
    }

    public void registerAdditionalBinders(Iterable<Binder> binders) {
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        for (Binder binder : binders) {
            binder.bind(dc);
        }
        dc.commit();
    }

    private void validate(List<Resource> resources) {
        ComponentModelValidator validator = new ComponentModelValidator(this.locator);
        validator.validate(new ResourceModel(resources));
        if (Errors.fatalIssuesFound()) {
            throw new ModelValidationException(ModelErrors.getErrorsAsResourceModelIssues());
        }
    }

    public Future<ContainerResponse> apply(ContainerRequest requestContext) {
        return this.apply(requestContext, new OutputStream(){

            @Override
            public void write(int i) throws IOException {
            }
        });
    }

    public Future<ContainerResponse> apply(ContainerRequest request, OutputStream outputStream) {
        FutureResponseWriter responseFuture = new FutureResponseWriter(request.getMethod(), outputStream);
        request.setSecurityContext(DEFAULT_SECURITY_CONTEXT);
        request.setWriter(responseFuture);
        this.handle(request);
        return responseFuture;
    }

    public void handle(ContainerRequest requestContext) {
        this.runtime.process(requestContext);
    }

    public ServiceLocator getServiceLocator() {
        return this.locator;
    }

    public ResourceConfig getConfiguration() {
        return this.runtimeConfig;
    }

    private class ApplicationBinder
    extends AbstractBinder {
        private ApplicationBinder() {
        }

        @Override
        protected void configure() {
            this.bindFactory(new RuntimeConfigProvider()).to(ServerConfig.class).to(Configuration.class).in(Singleton.class);
            this.bindFactory(new JaxrsApplicationProvider()).to(Application.class).in(Singleton.class);
            this.bind(ApplicationHandler.this).to(ApplicationHandler.class);
        }

        private class JaxrsApplicationProvider
        implements Factory<Application> {
            private JaxrsApplicationProvider() {
            }

            @Override
            public Application provide() {
                return ApplicationHandler.this.application;
            }

            @Override
            public void dispose(Application instance) {
            }
        }

        private class RuntimeConfigProvider
        implements Factory<ServerConfig> {
            private RuntimeConfigProvider() {
            }

            @Override
            public ServerConfig provide() {
                return ApplicationHandler.this.runtimeConfig;
            }

            @Override
            public void dispose(ServerConfig instance) {
            }
        }
    }

    private static class FutureResponseWriter
    extends AbstractFuture<ContainerResponse>
    implements ContainerResponseWriter {
        private static final Logger LOGGER = Logger.getLogger(FutureResponseWriter.class.getName());
        private static final Timer TIMER = new Timer("Jersey application request timer");
        private ContainerResponse response = null;
        private TimerTask timeoutTask = null;
        private ContainerResponseWriter.TimeoutHandler timeoutHandler = null;
        private boolean suspended = false;
        private final Object runtimeLock = new Object();
        private final String requestMethodName;
        private final OutputStream outputStream;

        private FutureResponseWriter(String requestMethodName, OutputStream outputStream) {
            this.requestMethodName = requestMethodName;
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse response) throws ContainerException {
            this.response = response;
            if (contentLength >= 0L) {
                response.getHeaders().putSingle("Content-Length", Long.toString(contentLength));
            }
            return this.outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean suspend(long time, TimeUnit unit, ContainerResponseWriter.TimeoutHandler handler) throws IllegalStateException {
            Object object = this.runtimeLock;
            synchronized (object) {
                if (this.suspended) {
                    return false;
                }
                this.suspended = true;
                this.timeoutHandler = handler;
                this.setSuspendTimeout(time, unit);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSuspendTimeout(long time, TimeUnit unit) throws IllegalStateException {
            TimerTask task = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = FutureResponseWriter.this.runtimeLock;
                        synchronized (object) {
                            FutureResponseWriter.this.timeoutHandler.onTimeout(FutureResponseWriter.this);
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.WARNING, LocalizationMessages.SUSPEND_HANDLER_EXECUTION_FAILED(), throwable);
                    }
                }
            };
            Object object = this.runtimeLock;
            synchronized (object) {
                if (!this.suspended) {
                    throw new IllegalStateException(LocalizationMessages.SUSPEND_NOT_SUSPENDED());
                }
                if (this.timeoutTask != null) {
                    this.timeoutTask.cancel();
                    this.timeoutTask = null;
                }
                if (time <= 0L) {
                    return;
                }
                this.timeoutTask = task;
                try {
                    TIMER.schedule(task, unit.toMillis(time));
                }
                catch (IllegalStateException ex) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.SUSPEND_SHEDULING_ERROR(), ex);
                }
            }
        }

        @Override
        public void commit() {
            ContainerResponse current = this.response;
            if (current != null) {
                if ("HEAD".equals(this.requestMethodName) && current.hasEntity()) {
                    current.setEntity(null);
                }
                super.set(current);
            }
        }

        @Override
        public void failure(Throwable error) {
            super.setException(error);
        }

        @Override
        protected void interruptTask() {
        }
    }
}

