/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.xml;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ext.ContextResolver;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

class MoxyContextResolver
implements ContextResolver<JAXBContext> {
    private static final String MOXY_OXM_MAPPING_FILE_NAME = "eclipselink-oxm.xml";
    private final boolean oxmMappingLookup;
    private final Map<String, Object> properties;
    private final ClassLoader classLoader;
    private final Class[] classes;

    public MoxyContextResolver() {
        this(Collections.emptyMap(), Thread.currentThread().getContextClassLoader(), false, new Class[0]);
    }

    public MoxyContextResolver(Map<String, Object> properties, ClassLoader classLoader, boolean oxmMappingLookup, Class ... classes) {
        this.properties = properties == null ? Collections.emptyMap() : properties;
        this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.oxmMappingLookup = oxmMappingLookup;
        this.classes = classes;
    }

    @Override
    public JAXBContext getContext(Class<?> type2) {
        InputStream eclipseLinkOxm;
        HashMap<String, Object> propertiesCopy = new HashMap<String, Object>(this.properties);
        if (this.oxmMappingLookup && (eclipseLinkOxm = type2.getResourceAsStream(MOXY_OXM_MAPPING_FILE_NAME)) != null && !propertiesCopy.containsKey("eclipselink.oxm.metadata-source")) {
            propertiesCopy.put("eclipselink.oxm.metadata-source", eclipseLinkOxm);
        }
        Class[] typeArray = new Class[]{type2};
        if (this.classes != null && this.classes.length > 0) {
            typeArray = new Class[typeArray.length + this.classes.length];
            System.arraycopy(this.classes, 0, typeArray, 0, this.classes.length);
            typeArray[typeArray.length - 1] = type2;
        }
        try {
            JAXBContext context = JAXBContextFactory.createContext(new Class[]{type2}, propertiesCopy, this.classLoader);
            Logger.getLogger(MoxyContextResolver.class.getName()).log(Level.FINE, "using context " + context);
            return context;
        }
        catch (JAXBException e) {
            return null;
        }
    }
}

