/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.json;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.jaxb.rs.MOXyJsonProvider;
import org.glassfish.jersey.moxy.json.MoxyJsonConfiguration;

@Produces(value={"*/*"})
@Consumes(value={"*/*"})
class ConfigurableMoxyJsonProvider
extends MOXyJsonProvider {
    @Context
    private Providers providers;

    ConfigurableMoxyJsonProvider() {
        this.setAttributePrefix("@");
        this.setValueWrapper("$");
        this.setNamespaceSeparator(':');
    }

    private void initializeProperties() {
        ContextResolver<MoxyJsonConfiguration> contextResolver = this.providers.getContextResolver(MoxyJsonConfiguration.class, MediaType.APPLICATION_JSON_TYPE);
        if (contextResolver != null) {
            MoxyJsonConfiguration jsonConfiguration = contextResolver.getContext(MoxyJsonConfiguration.class);
            if (jsonConfiguration.getAttributePrefix() != null) {
                this.setAttributePrefix(jsonConfiguration.getAttributePrefix());
            }
            if (jsonConfiguration.getValueWrapper() != null) {
                this.setValueWrapper(jsonConfiguration.getValueWrapper());
            }
            this.setFormattedOutput(jsonConfiguration.isFormattedOutput());
            this.setIncludeRoot(jsonConfiguration.isIncludeRoot());
            this.setMarshalEmptyCollections(jsonConfiguration.isMarshalEmptyCollections());
            this.setNamespaceSeparator(jsonConfiguration.getNamespaceSeparator());
            this.setNamespacePrefixMapper(jsonConfiguration.getNamespacePrefixMapper());
        }
    }

    private void initializeUnmarshaller(Unmarshaller unmarshaller) throws PropertyException {
        unmarshaller.setProperty("eclipselink.json.attribute-prefix", this.getAttributePrefix());
        unmarshaller.setProperty("eclipselink.json.include-root", this.isIncludeRoot());
        unmarshaller.setProperty("eclipselink.json.namespace-separator", Character.valueOf(this.getNamespaceSeparator()));
        unmarshaller.setProperty("eclipselink.json.value-wrapper", this.getValueWrapper());
        unmarshaller.setProperty("eclipselink.namespace-prefix-mapper", this.getNamespacePrefixMapper());
    }

    private void initializeMarshaller(Marshaller marshaller) throws PropertyException {
        marshaller.setProperty("jaxb.formatted.output", this.isFormattedOutput());
        marshaller.setProperty("eclipselink.json.attribute-prefix", this.getAttributePrefix());
        marshaller.setProperty("eclipselink.json.include-root", this.isIncludeRoot());
        marshaller.setProperty("eclipselink.json.marshal-empty-collections", this.isMarshalEmptyCollections());
        marshaller.setProperty("eclipselink.json.namespace-separator", Character.valueOf(this.getNamespaceSeparator()));
        marshaller.setProperty("eclipselink.json.value-wrapper", this.getValueWrapper());
        marshaller.setProperty("eclipselink.namespace-prefix-mapper", this.getNamespacePrefixMapper());
    }

    @Override
    protected void preReadFrom(Class<Object> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, Unmarshaller unmarshaller) throws JAXBException {
        super.preReadFrom(type2, genericType, annotations, mediaType, httpHeaders, unmarshaller);
        this.initializeProperties();
        this.initializeUnmarshaller(unmarshaller);
    }

    @Override
    protected void preWriteTo(Object object, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, Marshaller marshaller) throws JAXBException {
        super.preWriteTo(object, type2, genericType, annotations, mediaType, httpHeaders, marshaller);
        this.initializeProperties();
        this.initializeMarshaller(marshaller);
    }
}

