/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.message.internal.HttpHeaderReader;

public class QualitySourceMediaType
extends MediaType {
    public static final String QUALITY_SOURCE_PARAMETER_NAME = "qs";
    private final int qs;

    public QualitySourceMediaType(String type2, String subtype) {
        super(type2, subtype);
        this.qs = 1000;
    }

    public QualitySourceMediaType(String type2, String subtype, int quality, Map<String, String> parameters) {
        super(type2, subtype, parameters);
        this.qs = quality;
    }

    public int getQualitySource() {
        return this.qs;
    }

    public static QualitySourceMediaType valueOf(HttpHeaderReader reader) throws ParseException {
        reader.hasNext();
        String type2 = reader.nextToken();
        reader.nextSeparator('/');
        String subType = reader.nextToken();
        int qs = 1000;
        Map<String, String> parameters = null;
        if (reader.hasNext() && (parameters = HttpHeaderReader.readParameters(reader)) != null) {
            qs = QualitySourceMediaType.getQs(parameters.get(QUALITY_SOURCE_PARAMETER_NAME));
        }
        return new QualitySourceMediaType(type2, subType, qs, parameters);
    }

    public static int getQualitySource(MediaType mediaType) throws IllegalArgumentException {
        if (mediaType instanceof QualitySourceMediaType) {
            QualitySourceMediaType qsmt = (QualitySourceMediaType)mediaType;
            return qsmt.getQualitySource();
        }
        return QualitySourceMediaType.getQs(mediaType);
    }

    private static int getQs(MediaType mt) throws IllegalArgumentException {
        try {
            return QualitySourceMediaType.getQs(mt.getParameters().get(QUALITY_SOURCE_PARAMETER_NAME));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static int getQs(String v) throws ParseException {
        if (v == null) {
            return 1000;
        }
        try {
            int qs = (int)((double)Float.valueOf(v).floatValue() * 1000.0);
            if (qs < 0) {
                throw new ParseException("The quality source (qs) value, " + v + ", must be non-negative number", 0);
            }
            return qs;
        }
        catch (NumberFormatException ex) {
            ParseException pe = new ParseException("The quality source (qs) value, " + v + ", is not a valid value", 0);
            pe.initCause(ex);
            throw pe;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof QualitySourceMediaType) {
            QualitySourceMediaType other = (QualitySourceMediaType)obj;
            return this.qs == other.qs;
        }
        return this.qs == 1000;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return this.qs == 1000 ? hash : 47 * hash + this.qs;
    }
}

