/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.jersey.message.internal.OutboundMessageContext;

final class CommittingOutputStream
extends OutputStream {
    private OutputStream adaptedOutput;
    private boolean isCommitted = false;
    private OutboundMessageContext.StreamProvider streamProvider;

    public void setStreamProvider(OutboundMessageContext.StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b.length > 0) {
            this.commitWrite();
            this.adaptedOutput.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            this.commitWrite();
            this.adaptedOutput.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.commitWrite();
        this.adaptedOutput.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.commitWrite();
        this.adaptedOutput.flush();
    }

    @Override
    public void close() throws IOException {
        this.commitWrite();
        this.adaptedOutput.close();
    }

    private void commitWrite() throws IOException {
        if (!this.isCommitted) {
            this.isCommitted = true;
            this.streamProvider.commit();
            if (this.adaptedOutput == null) {
                this.adaptedOutput = this.streamProvider.getOutputStream();
            }
        }
    }
}

