/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import org.glassfish.jersey.message.internal.AbstractJaxbProvider;
import org.glassfish.jersey.message.internal.EntityInputStream;

public abstract class AbstractJaxbElementProvider
extends AbstractJaxbProvider<JAXBElement<?>> {
    public AbstractJaxbElementProvider(Providers ps) {
        super(ps);
    }

    public AbstractJaxbElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type2 == JAXBElement.class && genericType instanceof ParameterizedType && this.isSupported(mediaType);
    }

    @Override
    public boolean isWriteable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBElement.class.isAssignableFrom(type2) && this.isSupported(mediaType);
    }

    @Override
    public final JAXBElement<?> readFrom(Class<JAXBElement<?>> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        EntityInputStream entityStream = EntityInputStream.create(inputStream);
        if (entityStream.isEmpty()) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)genericType;
        Class ta = (Class)pt.getActualTypeArguments()[0];
        try {
            return this.readFrom(ta, mediaType, this.getUnmarshaller(ta, mediaType), entityStream);
        }
        catch (UnmarshalException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (JAXBException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected abstract JAXBElement<?> readFrom(Class<?> var1, MediaType var2, Unmarshaller var3, InputStream var4) throws JAXBException;

    @Override
    public final void writeTo(JAXBElement<?> t, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            Marshaller m = this.getMarshaller(t.getDeclaredType(), mediaType);
            Charset c = AbstractJaxbElementProvider.getCharset(mediaType);
            if (c != UTF8) {
                m.setProperty("jaxb.encoding", c.name());
            }
            this.setHeader(m, annotations);
            this.writeTo(t, mediaType, c, m, entityStream);
        }
        catch (JAXBException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected abstract void writeTo(JAXBElement<?> var1, MediaType var2, Charset var3, Marshaller var4, OutputStream var5) throws JAXBException;
}

