/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.message.MessageBodyWorkers;

public class OutboundEventWriter
implements MessageBodyWriter<OutboundEvent> {
    @Inject
    private Provider<MessageBodyWorkers> workersProvider;

    @Override
    public boolean isWriteable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type2.equals(OutboundEvent.class);
    }

    @Override
    public long getSize(OutboundEvent incomingEvent, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(OutboundEvent outboundEvent, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        if (outboundEvent.getComment() != null) {
            entityStream.write(String.format(": %s\n", outboundEvent.getComment()).getBytes());
        }
        if (outboundEvent.getType() != null) {
            MediaType eventMediaType = outboundEvent.getMediaType() == null ? MediaType.TEXT_PLAIN_TYPE : outboundEvent.getMediaType();
            MessageBodyWriter<Object> messageBodyWriter = this.workersProvider.get().getMessageBodyWriter(outboundEvent.getType(), outboundEvent.getType(), annotations, eventMediaType);
            if (outboundEvent.getName() != null) {
                entityStream.write(String.format("event: %s\n", outboundEvent.getName()).getBytes());
            }
            if (outboundEvent.getId() != null) {
                entityStream.write(String.format("id: %s\n", outboundEvent.getId()).getBytes());
            }
            messageBodyWriter.writeTo(outboundEvent.getData(), outboundEvent.getType(), outboundEvent.getType(), annotations, eventMediaType, httpHeaders, new OutputStream(){
                private boolean start = true;

                @Override
                public void write(int i) throws IOException {
                    if (this.start) {
                        entityStream.write("data: ".getBytes());
                        this.start = false;
                    }
                    entityStream.write(i);
                    if (i == 10) {
                        entityStream.write("data: ".getBytes());
                    }
                }
            });
        }
        entityStream.write("\n\n".getBytes());
        entityStream.flush();
    }
}

